/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tg;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.herac.tuxguitar.song.models.BendEffect;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.TrackColor;
import org.herac.tuxguitar.song.models.Tupleto;

public class TGInputStream {
    private static final String TG_VERSION = "TG_DEVEL-0.01";
    private DataInputStream dataInputStream;

    public TGInputStream(FileInputStream fileInputStream) throws FileNotFoundException {
        this.dataInputStream = new DataInputStream(fileInputStream);
    }

    public TGInputStream(String string) throws FileNotFoundException {
        this(new FileInputStream(new File(string)));
    }

    public Song read() {
        try {
            String string = this.readVersion();
            Song song = this.readSong();
            this.dataInputStream.close();
            return song;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private String readVersion() {
        String string = this.readString();
        return string;
    }

    private Song readSong() {
        String string = this.readString();
        String string2 = this.readString();
        String string3 = this.readString();
        String string4 = this.readString();
        int n = this.readInt();
        ArrayList<SongTrack> arrayList = new ArrayList<SongTrack>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.readTrack());
        }
        return new Song(string, string2, string3, string4, arrayList, 10);
    }

    private SongTrack readTrack() {
        int n;
        long l = this.readLong();
        String string = this.readString();
        SongChannel songChannel = this.readChannel();
        int n2 = this.readInt();
        ArrayList<Measure> arrayList = new ArrayList<Measure>(n2);
        for (n = 0; n < n2; ++n) {
            arrayList.add(this.readMeasure());
        }
        n = this.readInt();
        ArrayList<InstrumentString> arrayList2 = new ArrayList<InstrumentString>(n);
        for (int i = 0; i < n; ++i) {
            arrayList2.add(this.readInstrumentString());
        }
        TrackColor trackColor = this.readTrackColor();
        return new SongTrack(l, string, songChannel, arrayList, arrayList2, trackColor);
    }

    private Measure readMeasure() {
        int n;
        int n2 = this.readInt();
        long l = this.readLong();
        int n3 = this.readInt();
        ArrayList<Note> arrayList = new ArrayList<Note>(n3);
        for (n = 0; n < n3; ++n) {
            arrayList.add(this.readNote());
        }
        n = this.readInt();
        ArrayList<Silence> arrayList2 = new ArrayList<Silence>(n);
        for (int i = 0; i < n; ++i) {
            arrayList2.add(this.readSilence());
        }
        TimeSignature timeSignature = this.readTimeSignature();
        Tempo tempo = this.readTempo();
        boolean bl = this.readBoolean();
        int n4 = this.readInt();
        return new Measure(n2, l, arrayList, arrayList2, timeSignature, tempo, bl, n4);
    }

    private Note readNote() {
        int n = this.readInt();
        long l = this.readLong();
        Duration duration = this.readDuration();
        int n2 = this.readInt();
        int n3 = this.readInt();
        boolean bl = this.readBoolean();
        NoteEffect noteEffect = this.readNoteEffect();
        return new Note(n, l, duration, n2, n3, bl, noteEffect);
    }

    private SongChannel readChannel() {
        short s = this.readShort();
        short s2 = this.readShort();
        short s3 = this.readShort();
        short s4 = this.readShort();
        short s5 = this.readShort();
        short s6 = this.readShort();
        short s7 = this.readShort();
        short s8 = this.readShort();
        short s9 = this.readShort();
        boolean bl = this.readBoolean();
        boolean bl2 = this.readBoolean();
        return new SongChannel(s, s2, s3, s4, s5, s6, s7, s8, s9, bl, bl2);
    }

    private Silence readSilence() {
        long l = this.readLong();
        Duration duration = this.readDuration();
        return new Silence(l, duration);
    }

    private InstrumentString readInstrumentString() {
        int n = this.readInt();
        int n2 = this.readInt();
        return new InstrumentString(n, n2);
    }

    private Tempo readTempo() {
        int n = this.readInt();
        return new Tempo(n);
    }

    private TimeSignature readTimeSignature() {
        int n = this.readInt();
        Duration duration = this.readDuration();
        return new TimeSignature(n, duration);
    }

    private Duration readDuration() {
        int n = this.readInt();
        boolean bl = this.readBoolean();
        boolean bl2 = this.readBoolean();
        Tupleto tupleto = this.readTupleto();
        return new Duration(n, bl, bl2, tupleto);
    }

    private Tupleto readTupleto() {
        int n = this.readInt();
        int n2 = this.readInt();
        return new Tupleto(n, n2);
    }

    private NoteEffect readNoteEffect() {
        NoteEffect noteEffect = new NoteEffect();
        noteEffect.setVibrato(this.readBoolean());
        if (this.readBoolean()) {
            noteEffect.setBend(this.readBendEffect());
        }
        noteEffect.setDeadNote(this.readBoolean());
        noteEffect.setSlide(this.readBoolean());
        noteEffect.setHammer(this.readBoolean());
        return noteEffect;
    }

    private BendEffect readBendEffect() {
        BendEffect bendEffect = new BendEffect();
        int n = this.readInt();
        for (int i = 0; i < n; ++i) {
            int n2 = this.readInt();
            int n3 = this.readInt();
            bendEffect.addPoint(n2, n3);
        }
        return bendEffect;
    }

    private TrackColor readTrackColor() {
        int n = this.readInt();
        int n2 = this.readInt();
        int n3 = this.readInt();
        return new TrackColor(n, n2, n3);
    }

    private short readShort() {
        try {
            return this.dataInputStream.readShort();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    private int readInt() {
        try {
            return this.dataInputStream.readInt();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    private long readLong() {
        try {
            return this.dataInputStream.readLong();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0L;
        }
    }

    private String readString() {
        try {
            int n = this.dataInputStream.read();
            char[] cArray = new char[n];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = this.dataInputStream.readChar();
            }
            return String.copyValueOf(cArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private boolean readBoolean() {
        try {
            return this.dataInputStream.readBoolean();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }
}

