/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.gui.tab.TablatureUtil;
import org.herac.tuxguitar.io.gp.GPFormatException;
import org.herac.tuxguitar.song.models.BendEffect;
import org.herac.tuxguitar.song.models.Component;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.TrackColor;

public class GP4OutputStream {
    private static final String GP4_VERSION = "FICHIER GUITAR PRO v4.00";
    private OutputStream outputStream;

    public GP4OutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void writeSong(Song song) throws IOException {
        try {
            int n;
            SongTrack songTrack = null;
            Measure measure = null;
            int n2 = song.getTracks().size();
            if (n2 > 0) {
                songTrack = (SongTrack)song.getTracks().get(0);
            }
            int n3 = 0;
            if (songTrack != null) {
                n3 = songTrack.getMeasures().size();
            }
            if (n3 > 0) {
                measure = (Measure)songTrack.getMeasures().get(0);
            }
            this.writeStringByte(GP4_VERSION, 30);
            this.writeStringIntegerPlusOne(song.getName());
            this.writeStringIntegerPlusOne("");
            this.writeStringIntegerPlusOne(song.getInterpret());
            this.writeStringIntegerPlusOne(song.getAlbum());
            this.writeStringIntegerPlusOne(song.getAuthor());
            this.writeStringIntegerPlusOne("");
            this.writeStringIntegerPlusOne("");
            this.writeStringIntegerPlusOne("");
            this.writeInt(0);
            this.writeBoolean(false);
            this.writeInt(0);
            for (int i = 0; i < 5; ++i) {
                this.writeInt(0);
                this.writeStringInteger("");
            }
            Tempo tempo = new Tempo(120);
            if (measure != null) {
                tempo = (Tempo)measure.getTempo().clone();
            }
            this.writeInt(tempo.getValue());
            this.writeByte((byte)0);
            this.writeInt(0);
            SongChannel[] songChannelArray = this.makeChannels(song);
            for (n = 0; n < songChannelArray.length; ++n) {
                this.writeInt(songChannelArray[n].getInstrument());
                this.writeByte(this.toChannelByte(songChannelArray[n].getVolume()));
                this.writeByte(this.toChannelByte(songChannelArray[n].getBalance()));
                this.writeByte(this.toChannelByte(songChannelArray[n].getChorus()));
                this.writeByte(this.toChannelByte(songChannelArray[n].getReverb()));
                this.writeByte(this.toChannelByte(songChannelArray[n].getPhaser()));
                this.writeByte(this.toChannelByte(songChannelArray[n].getTremolo()));
                byte[] byArray = new byte[]{0, 0};
                this.outputStream.write(byArray);
            }
            this.writeInt(n3);
            this.writeInt(n2);
            if (songTrack != null) {
                this.createMeasures(songTrack.getMeasures());
            }
            this.createTracks(song.getTracks());
            for (n = 0; n < n3; ++n) {
                for (int i = 0; i < n2; ++i) {
                    SongTrack songTrack2 = (SongTrack)song.getTracks().get(i);
                    Measure measure2 = (Measure)songTrack2.getMeasures().get(n);
                    this.addMeasureComponents(songTrack2.getStrings().size(), measure2, tempo);
                }
            }
            this.outputStream.flush();
            this.outputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void createMeasures(List list) throws IOException {
        TimeSignature timeSignature = new TimeSignature(0, new Duration(0));
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Measure measure = (Measure)list.get(i);
                this.createMeasure(measure, timeSignature);
                timeSignature.setNumerator(measure.getTimeSignature().getNumerator());
                timeSignature.getDenominator().setValue(measure.getTimeSignature().getDenominator().getValue());
            }
        }
    }

    private void createMeasure(Measure measure, TimeSignature timeSignature) throws IOException {
        int n = 0;
        if (measure.getTimeSignature().getNumerator() != timeSignature.getNumerator()) {
            n |= 1;
        }
        if (measure.getTimeSignature().getDenominator().getValue() != timeSignature.getDenominator().getValue()) {
            n |= 2;
        }
        if (measure.isRepeatStart()) {
            n |= 4;
        }
        if (measure.getNumberOfRepetitions() > 0) {
            n |= 8;
        }
        this.writeUnsignedByte(n);
        if ((n & 1) != 0) {
            this.writeByte((byte)measure.getTimeSignature().getNumerator());
        }
        if ((n & 2) != 0) {
            this.writeByte((byte)measure.getTimeSignature().getDenominator().getValue());
        }
        if ((n & 8) != 0) {
            this.writeByte((byte)measure.getNumberOfRepetitions());
        }
    }

    private void createTracks(List list) throws IOException {
        for (int i = 0; i < list.size(); ++i) {
            SongTrack songTrack = (SongTrack)list.get(i);
            this.createTrack(songTrack);
        }
    }

    private void createTrack(SongTrack songTrack) throws IOException {
        int n = 0;
        if (songTrack.isPercusionTrack()) {
            n |= 1;
        }
        this.writeUnsignedByte(n);
        this.writeStringByte(songTrack.getName(), 40);
        this.writeInt(songTrack.getStrings().size());
        for (int i = 0; i < 7; ++i) {
            int n2 = 0;
            if (songTrack.getStrings().size() > i) {
                InstrumentString instrumentString = (InstrumentString)songTrack.getStrings().get(i);
                n2 = instrumentString.getValue();
            }
            this.writeInt(n2);
        }
        this.writeInt(1);
        this.writeInt(songTrack.getChannel().getChannel() + 1);
        this.writeInt(songTrack.getChannel().getEffectChannel() + 1);
        this.writeInt(24);
        this.writeInt(0);
        this.writeColor(songTrack.getColor());
    }

    private void addMeasureComponents(int n, Measure measure, Tempo tempo) throws IOException, GPFormatException {
        List list = this.getBeats(measure);
        this.writeInt(list.size());
        for (int i = 0; i < list.size(); ++i) {
            MeasureBeat measureBeat = (MeasureBeat)list.get(i);
            this.addNotes(measureBeat, n, measure, tempo);
        }
    }

    private void addNotes(MeasureBeat measureBeat, int n, Measure measure, Tempo tempo) throws IOException, GPFormatException {
        Note note;
        int n2;
        Duration duration = measureBeat.getDuration();
        int n3 = 0;
        if (duration.isDotted()) {
            n3 |= 1;
        }
        if (!duration.getTupleto().isEqual(Duration.NO_TUPLETO)) {
            n3 |= 0x20;
        }
        if (measure.getTempo().getValue() != tempo.getValue()) {
            n3 |= 0x10;
        }
        Object var7_7 = null;
        if (measureBeat.isSilence()) {
            n3 |= 0x40;
        }
        this.writeUnsignedByte(n3);
        if ((n3 & 0x40) != 0) {
            this.writeUnsignedByte(2);
        }
        this.writeByte(this.parseDuration(duration));
        if ((n3 & 0x20) != 0) {
            this.writeInt(duration.getTupleto().getEnters());
        }
        if ((n3 & 0x10) != 0) {
            this.writeMixChange(measure.getTempo());
        }
        int n4 = 0;
        if (!measureBeat.isSilence()) {
            for (n2 = 0; n2 < measureBeat.getNotes().size(); ++n2) {
                note = (Note)measureBeat.getNotes().get(n2);
                int n5 = 7 - note.getString();
                n4 |= 1 << n5;
            }
        }
        this.writeUnsignedByte(n4);
        for (n2 = 0; n2 < measureBeat.getNotes().size(); ++n2) {
            note = (Note)measureBeat.getNotes().get(n2);
            this.writeNote(note);
        }
    }

    private void writeNote(Note note) throws IOException {
        int n = 32;
        if (note.getEffect().hasEffects()) {
            n |= 8;
        }
        this.writeUnsignedByte(n);
        if ((n & 0x20) != 0) {
            int n2 = 1;
            if (note.isTiedNote()) {
                n2 = 2;
            } else if (note.getEffect().isDeadNote()) {
                n2 = 3;
            }
            this.writeUnsignedByte(n2);
        }
        if ((n & 0x20) != 0) {
            this.writeByte((byte)note.getValue());
        }
        if ((n & 8) != 0) {
            this.writeNoteEffects(note.getEffect());
        }
    }

    private byte parseDuration(Duration duration) {
        byte by = 0;
        switch (duration.getValue()) {
            case 1: {
                by = -2;
                break;
            }
            case 2: {
                by = -1;
                break;
            }
            case 4: {
                by = 0;
                break;
            }
            case 8: {
                by = 1;
                break;
            }
            case 16: {
                by = 2;
                break;
            }
            case 32: {
                by = 3;
                break;
            }
            case 64: {
                by = 4;
            }
        }
        return by;
    }

    private void writeNoteEffects(NoteEffect noteEffect) throws IOException {
        int n = 0;
        int n2 = 0;
        if (noteEffect.isBend()) {
            n |= 1;
        }
        if (noteEffect.isHammer()) {
            n |= 2;
        }
        if (noteEffect.isSlide()) {
            n2 |= 8;
        }
        if (noteEffect.isVibrato()) {
            n2 |= 0x40;
        }
        this.writeUnsignedByte(n);
        this.writeUnsignedByte(n2);
        if ((n & 1) != 0) {
            this.writeBend(noteEffect.getBend());
        }
        if ((n2 & 8) != 0) {
            this.writeByte((byte)0);
        }
    }

    private void writeBend(BendEffect bendEffect) throws IOException {
        this.writeByte((byte)0);
        this.writeInt(0);
        int n = bendEffect.getPoints().size();
        this.writeInt(n);
        for (int i = 0; i < n; ++i) {
            BendEffect.BendPoint bendPoint = (BendEffect.BendPoint)bendEffect.getPoints().get(i);
            int n2 = bendPoint.getPosition() * 60 / 12;
            int n3 = bendPoint.getValue() * 100 / 8;
            this.writeInt(n2);
            this.writeInt(n3);
            this.writeByte((byte)0);
        }
    }

    private void writeMixChange(Tempo tempo) throws IOException {
        for (int i = 0; i < 7; ++i) {
            this.writeByte((byte)-1);
        }
        this.writeInt(tempo.getValue());
        this.writeByte((byte)0);
        this.writeUnsignedByte(1);
    }

    private List getBeats(Measure measure) {
        boolean bl = !measure.getSilences().isEmpty();
        this.orderNotes(measure);
        ArrayList<MeasureBeat> arrayList = new ArrayList<MeasureBeat>();
        MeasureBeat measureBeat = null;
        Iterator iterator = null;
        for (Component component : measure.getNotes()) {
            long l;
            if (measureBeat == null) {
                measureBeat = new MeasureBeat(((Note)component).getDuration(), ((Note)component).getStart());
            }
            if (!bl && arrayList.isEmpty() && measureBeat.getStart() != measure.getStart() && (l = measureBeat.getStart() - measure.getStart()) > 10L) {
                this.createSilenceBeats(arrayList, measureBeat.getStart() + measureBeat.getDuration().getTime(), l);
            }
            if (((Note)component).getStart() != measureBeat.getStart()) {
                arrayList.add(measureBeat);
                if (!bl && (l = ((Note)component).getStart() - (measureBeat.getStart() + measureBeat.getDuration().getTime())) > 10L) {
                    this.createSilenceBeats(arrayList, measureBeat.getStart() + measureBeat.getDuration().getTime(), l);
                }
                measureBeat = new MeasureBeat(((Note)component).getDuration(), ((Note)component).getStart());
            }
            measureBeat.addNote((Note)component);
        }
        if (measureBeat != null) {
            arrayList.add(measureBeat);
        }
        if (bl) {
            for (Component component : measure.getSilences()) {
                arrayList.add(new MeasureBeat(((Silence)component).getDuration(), ((Silence)component).getStart()));
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            MeasureBeat measureBeat2 = null;
            for (int j = i; j < arrayList.size(); ++j) {
                MeasureBeat measureBeat3 = (MeasureBeat)arrayList.get(j);
                if (measureBeat2 != null && measureBeat3.getStart() >= measureBeat2.getStart()) continue;
                measureBeat2 = measureBeat3;
            }
            arrayList.remove(measureBeat2);
            arrayList.add(i, measureBeat2);
        }
        return arrayList;
    }

    private void createSilenceBeats(List list, long l, long l2) {
        List list2 = TablatureUtil.createDurations(l2);
        for (Duration duration : list2) {
            list.add(new MeasureBeat(duration, l));
            l += duration.getTime();
        }
    }

    private void orderNotes(Measure measure) {
        for (int i = 0; i < measure.getNotes().size(); ++i) {
            Note note = null;
            for (int j = i; j < measure.getNotes().size(); ++j) {
                Note note2 = (Note)measure.getNotes().get(j);
                if (note != null && note2.getStart() >= note.getStart() && (note2.getStart() != note.getStart() || note2.getString() >= note.getString())) continue;
                note = note2;
            }
            measure.getNotes().remove(note);
            measure.getNotes().add(i, note);
        }
    }

    private SongChannel[] makeChannels(Song song) {
        SongChannel[] songChannelArray = new SongChannel[64];
        for (int i = 0; i < songChannelArray.length; ++i) {
            songChannelArray[i] = new SongChannel((short)i, (short)i, 24, 13, 8, 0, 0, 0, 0, false, false);
        }
        for (SongTrack songTrack : song.getTracks()) {
            songChannelArray[songTrack.getChannel().getChannel()].setInstrument(songTrack.getChannel().getInstrument());
            songChannelArray[songTrack.getChannel().getChannel()].setVolume(songTrack.getChannel().getVolume());
            songChannelArray[songTrack.getChannel().getChannel()].setBalance(songTrack.getChannel().getBalance());
            songChannelArray[songTrack.getChannel().getEffectChannel()].setInstrument(songTrack.getChannel().getInstrument());
            songChannelArray[songTrack.getChannel().getEffectChannel()].setVolume(songTrack.getChannel().getVolume());
            songChannelArray[songTrack.getChannel().getEffectChannel()].setBalance(songTrack.getChannel().getBalance());
        }
        return songChannelArray;
    }

    private void writeColor(TrackColor trackColor) throws IOException {
        this.writeUnsignedByte(trackColor.getR());
        this.writeUnsignedByte(trackColor.getG());
        this.writeUnsignedByte(trackColor.getB());
        this.outputStream.write(0);
    }

    private void writeBoolean(boolean bl) throws IOException {
        this.outputStream.write(bl ? 1 : 0);
    }

    private void writeByte(byte by) throws IOException {
        this.outputStream.write(by);
    }

    private void writeUnsignedByte(int n) throws IOException {
        this.outputStream.write(n);
    }

    private void writeStringByte(String string, int n) throws IOException {
        byte[] byArray = string.getBytes();
        this.writeUnsignedByte(byArray.length);
        if (n != 0) {
            byte[] byArray2 = new byte[n];
            for (int i = 0; i < byArray.length; ++i) {
                byArray2[i] = byArray[i];
            }
            byArray = byArray2;
        }
        this.outputStream.write(byArray);
    }

    private void writeStringIntegerPlusOne(String string) throws IOException {
        byte[] byArray = string.getBytes();
        this.writeInt(byArray.length + 1);
        this.outputStream.write(byArray.length);
        this.outputStream.write(byArray);
    }

    private void writeStringInteger(String string) throws IOException {
        byte[] byArray = string.getBytes();
        this.writeInt(byArray.length);
        this.outputStream.write(byArray);
    }

    private void writeInt(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        this.outputStream.write(byArray);
    }

    private byte toChannelByte(short n) {
        n = (n = (short)(n * 16 / 127)) <= 16 ? n : 16;
        return (byte)n;
    }

    private class MeasureBeat {
        private Duration duration;
        private List notes;
        private boolean silence;
        private long start;

        public MeasureBeat(Duration duration, long l) {
            this.duration = duration;
            this.start = l;
            this.notes = new ArrayList();
            this.silence = true;
        }

        public long getStart() {
            return this.start;
        }

        public void setStart(long l) {
            this.start = l;
        }

        public Duration getDuration() {
            return this.duration;
        }

        public void addNote(Note note) {
            this.getNotes().add(note);
            this.silence = false;
        }

        public List getNotes() {
            return this.notes;
        }

        private boolean isSilence() {
            return this.silence;
        }
    }
}

