/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.herac.tuxguitar.io.gp.GP3InputStream;
import org.herac.tuxguitar.io.gp.GP4InputStream;
import org.herac.tuxguitar.io.gp.GP5InputStream;
import org.herac.tuxguitar.io.gp.GPFormatException;
import org.herac.tuxguitar.io.tg.TGInputStream;
import org.herac.tuxguitar.song.models.Song;

public class SongLoader {
    private static final String TG_EXTENSION = ".TG";
    private static final String GP3_EXTENSION = ".GP3";
    private static final String GP4_EXTENSION = ".GP4";
    private static final String GP5_EXTENSION = ".GP5";
    private String fileName;

    public SongLoader(String string) {
        this.fileName = string;
    }

    public Song load() throws GPFormatException, IOException {
        Song song = null;
        if (this.hasExtension(TG_EXTENSION)) {
            song = this.loadTGFile();
        } else if (this.hasExtension(GP3_EXTENSION)) {
            song = this.loadGP3File();
        } else if (this.hasExtension(GP4_EXTENSION)) {
            song = this.loadGP4File();
        } else if (this.hasExtension(GP5_EXTENSION)) {
            song = this.loadGP5File();
        }
        return song;
    }

    private boolean hasExtension(String string) {
        return this.fileName.toUpperCase().endsWith(string);
    }

    private Song loadTGFile() throws FileNotFoundException {
        Song song = new TGInputStream(this.fileName).read();
        return song;
    }

    private Song loadGP3File() throws GPFormatException, IOException {
        GP3InputStream gP3InputStream = new GP3InputStream(this.fileName);
        return gP3InputStream.readSong();
    }

    private Song loadGP4File() throws GPFormatException, IOException {
        GP4InputStream gP4InputStream = new GP4InputStream(this.fileName);
        return gP4InputStream.readSong();
    }

    private Song loadGP5File() throws GPFormatException, IOException {
        GP5InputStream gP5InputStream = new GP5InputStream(this.fileName);
        return gP5InputStream.readSong();
    }
}

