/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.measure;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;

public class UndoableAddMeasure
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private long undoablePosition;

    private UndoableAddMeasure() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TuxGuitar.instance().getSongManager().addNewMeasureBeforeEnd();
        int n = UndoableAddMeasure.getCaret().getSongTrackCoords().getTrack().getMeasures().size();
        TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(n, true);
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        TuxGuitar.instance().getSongManager().removeMeasure(this.undoablePosition);
        TuxGuitar.instance().fireUpdate();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableAddMeasure startUndo() {
        UndoableAddMeasure undoableAddMeasure = new UndoableAddMeasure();
        Caret caret = UndoableAddMeasure.getCaret();
        undoableAddMeasure.undoCaret = new UndoableCaretHelper();
        undoableAddMeasure.doAction = 1;
        return undoableAddMeasure;
    }

    public UndoableAddMeasure endUndo(long l) {
        this.redoCaret = new UndoableCaretHelper();
        this.undoablePosition = l;
        return this;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }
}

