/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.component;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Measure;

public class UndoableComponentGeneric
implements UndoableEdit {
    private int doAction;
    private long trackNumber;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private UndoComponent undoComponent;
    private RedoComponent redoComponent;

    private UndoableComponentGeneric() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        this.redoComponent.redo();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this.undoComponent.undo();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableComponentGeneric startUndo() {
        UndoableComponentGeneric undoableComponentGeneric = new UndoableComponentGeneric();
        Caret caret = UndoableComponentGeneric.getCaret();
        undoableComponentGeneric.doAction = 1;
        undoableComponentGeneric.trackNumber = caret.getSongTrackCoords().getTrack().getNumber();
        undoableComponentGeneric.undoCaret = new UndoableCaretHelper();
        UndoableComponentGeneric undoableComponentGeneric2 = undoableComponentGeneric;
        undoableComponentGeneric2.getClass();
        undoableComponentGeneric.undoComponent = undoableComponentGeneric2.new UndoComponent(caret.getMeasureCoords().getMeasure(), caret.getDuration());
        return undoableComponentGeneric;
    }

    public UndoableComponentGeneric endUndo() {
        Caret caret = UndoableComponentGeneric.getCaret();
        this.redoCaret = new UndoableCaretHelper();
        this.redoComponent = new RedoComponent(caret.getMeasureCoords().getMeasure(), caret.getDuration());
        return this;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }

    private class RedoComponent {
        private Measure measure;
        private Duration caretDuration;

        public RedoComponent(Measure measure, Duration duration) {
            if (measure != null) {
                this.measure = (Measure)measure.clone();
            }
            this.caretDuration = (Duration)duration.clone();
        }

        public void redo() {
            SongTrackCoords songTrackCoords = UndoableComponentGeneric.getCaret().getSongCoords().getTrack(UndoableComponentGeneric.this.trackNumber);
            if (songTrackCoords != null && this.measure != null) {
                Measure measure = TuxGuitar.instance().getSongManager().getTrackManager().replaceMeasure(songTrackCoords.getTrack(), (Measure)this.measure.clone());
                UndoableComponentGeneric.getCaret().setSelectedDuration((Duration)this.caretDuration.clone());
                TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(measure.getNumber(), false);
            }
        }
    }

    private class UndoComponent {
        private Measure measure;
        private Duration caretDuration;

        public UndoComponent(Measure measure, Duration duration) {
            if (measure != null) {
                this.measure = (Measure)measure.clone();
                this.caretDuration = (Duration)duration.clone();
            }
        }

        public void undo() {
            SongTrackCoords songTrackCoords = UndoableComponentGeneric.getCaret().getSongCoords().getTrack(UndoableComponentGeneric.this.trackNumber);
            if (songTrackCoords != null && this.measure != null) {
                Measure measure = TuxGuitar.instance().getSongManager().getTrackManager().replaceMeasure(songTrackCoords.getTrack(), (Measure)this.measure.clone());
                UndoableComponentGeneric.getCaret().setSelectedDuration((Duration)this.caretDuration.clone());
                TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(measure.getNumber(), false);
            }
        }
    }
}

