/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab.layout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.gui.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.InstrumentString;

public class PageViewLayout
extends ViewLayout {
    private int displayWidth;
    private int divisionCount;

    public PageViewLayout(Tablature tablature, SongManager songManager, boolean bl) {
        super(tablature, songManager, bl);
        this.displayWidth = this.getTablature().getDisplay().getBounds().width - 35;
    }

    public void paintSong(GC gC, Rectangle rectangle, int n, int n2) {
        if (this.isMultitrack()) {
            this.paintTracks(this.getTablature().getCaret().getSongCoords().getTrackCoords(), gC, rectangle, n, n2);
        } else {
            ArrayList<SongTrackCoords> arrayList = new ArrayList<SongTrackCoords>();
            arrayList.add(this.getTablature().getCaret().getSongTrackCoords());
            this.paintTracks(arrayList, gC, rectangle, n, n2);
        }
    }

    public void paintTracks(List list, GC gC, Rectangle rectangle, int n, int n2) {
        int n3 = n2 + 50;
        for (int i = 0; i < list.size(); ++i) {
            SongTrackCoords songTrackCoords = (SongTrackCoords)list.get(i);
            songTrackCoords.paintTrack(this, gC, n, n3, rectangle);
            n3 += 150;
        }
    }

    public void paintMeasures(SongTrackCoords songTrackCoords, List list, GC gC, int n, int n2, Rectangle rectangle) {
        int n3;
        songTrackCoords.setPosY(n2);
        int n4 = songTrackCoords.getPosX();
        int n5 = songTrackCoords.getPosY();
        int n6 = 0;
        int n7 = 0;
        this.divisionCount = 1;
        int n8 = 20;
        ArrayList<MeasureCoords> arrayList = new ArrayList<MeasureCoords>();
        for (n3 = 0; n3 < list.size(); ++n3) {
            boolean bl;
            MeasureCoords measureCoords = (MeasureCoords)list.get(n3);
            measureCoords.calculateWidth();
            boolean bl2 = n4 + n > rectangle.x - 1500 && n4 + n < rectangle.x + rectangle.width + 100;
            boolean bl3 = bl = n5 > rectangle.y - 150 && n5 < rectangle.y + rectangle.height + 150;
            if (n8 + measureCoords.getWidth() >= this.getMaxWidth() && !arrayList.isEmpty()) {
                int n9 = 0;
                int n10 = this.getMaxWidth() - n8;
                if (n10 != 0 && arrayList.size() > 0) {
                    n9 = n10 / arrayList.size();
                }
                for (MeasureCoords measureCoords2 : arrayList) {
                    measureCoords2.setPosX(n4);
                    measureCoords2.setPosY(n5);
                    if (bl2 && bl) {
                        this.paintMeasure(measureCoords2, gC, n4 + n, n5, n9, rectangle);
                    } else {
                        measureCoords2.setOutOfBounds(true);
                    }
                    if ((n4 += measureCoords2.getWidth() + measureCoords2.getSpan()) <= n6) continue;
                    n6 = n4;
                }
                if (bl2 && bl) {
                    this.paintStrings(songTrackCoords, gC, n, n5, n4);
                }
                n4 = songTrackCoords.getPosX();
                n5 += this.getLinearSpan();
                n7 += this.getLinearSpan();
                n8 = 20;
                arrayList.clear();
                ++this.divisionCount;
            }
            n8 += measureCoords.getWidth();
            arrayList.add(measureCoords);
        }
        n3 = n4 + n > rectangle.x - 1500 && n4 + n < rectangle.x + rectangle.width + 100 ? 1 : 0;
        boolean bl = n5 > rectangle.y - 150 && n5 < rectangle.y + rectangle.height + 150;
        for (MeasureCoords measureCoords : arrayList) {
            measureCoords.setPosX(n4);
            measureCoords.setPosY(n5);
            if (n3 != 0 && bl) {
                this.paintMeasure(measureCoords, gC, n4 + n, n5, 0, rectangle);
            }
            if ((n4 += measureCoords.getWidth() + measureCoords.getSpan()) <= n6) continue;
            n6 = n4;
        }
        if (n3 != 0 && bl) {
            int n11 = this.getMaxWidth() - 15;
            n11 = n4 > n11 - 20 ? n4 : n11;
            this.paintStrings(songTrackCoords, gC, n, n5, n11);
        }
        this.setWidth(n6);
        this.setHeight((n7 += this.getLinearSpan()) + 150 + 100);
    }

    public void paintStrings(SongTrackCoords songTrackCoords, GC gC, int n, int n2, int n3) {
        int n4 = songTrackCoords.getPosX();
        for (InstrumentString instrumentString : songTrackCoords.getTrack().getStrings()) {
            int n5 = instrumentString.getNumber() * this.getStringSpan();
            gC.drawLine(n + n4, n2 + n5, n + n3, n2 + n5);
        }
    }

    public SongTrackCoords getTrackAt(List arrayList, int n, int n2) {
        if (!this.isMultitrack()) {
            arrayList = new ArrayList<SongTrackCoords>();
            arrayList.add(this.getTablature().getCaret().getSongTrackCoords());
        }
        SongTrackCoords songTrackCoords = null;
        int n3 = this.getLinearSpan();
        for (int i = 0; i < arrayList.size(); ++i) {
            SongTrackCoords songTrackCoords2 = (SongTrackCoords)arrayList.get(i);
            int n4 = songTrackCoords2.getHeight();
            for (int j = 0; j < this.divisionCount; ++j) {
                int n5 = songTrackCoords2.getPosY() + j * n3;
                if (n >= n5 - 75 && n <= n5 + n4 + 75) {
                    songTrackCoords = songTrackCoords2;
                }
                n5 += n3;
            }
        }
        return songTrackCoords;
    }

    public void followMeasure(MeasureCoords measureCoords, boolean bl) {
        this.getTablature().moveScrollVerticalTo(measureCoords, 50, 50, bl);
    }

    private int getLinearSpan() {
        int n = 200;
        if (this.isMultiTrack()) {
            n *= this.getTrackCount();
        }
        return n;
    }

    public int getMaxWidth() {
        return this.displayWidth;
    }
}

