/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.printer;

import java.net.URI;
import java.net.URISyntaxException;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.PageRanges;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.printing.PrinterData;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.printer.PrintableImpl;

public class Printer
extends Device {
    private PrinterData printerData;
    private DocPrintJob printJob;
    private String jobName;
    private long defaultFont;
    private Image image;
    private PrintDocument document;

    public Printer() {
        this(Printer.getDefaultPrinterData());
    }

    public Printer(PrinterData printerData) {
        super((DeviceData)printerData);
        this.printerData = printerData;
        this.document = new PrintDocument();
        this.initializeSystemResources();
    }

    public Image getImage() {
        if (this.image == null) {
            this.createImage(1024, 768);
        }
        return this.image;
    }

    private void createImage(int n, int n2) {
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
        }
        this.image = new Image((Device)this, n, n2);
    }

    private void initializeSystemResources() {
        long l = OS.gtk_window_new((int)0);
        long l2 = OS.gtk_widget_get_style((long)l);
        this.defaultFont = OS.pango_font_description_copy((long)OS.gtk_style_get_font_desc((long)l2));
    }

    public Printer(DeviceData deviceData) {
        super(deviceData);
    }

    public long internal_new_GC(GCData gCData) {
        return this.getImage().internal_new_GC(gCData);
    }

    public void internal_dispose_GC(long l, GCData gCData) {
        this.getImage().internal_dispose_GC(l, gCData);
    }

    public Font getSystemFont() {
        this.checkDevice();
        return Font.gtk_new((Device)this, (long)this.defaultFont);
    }

    public static PrinterData[] getPrinterList() {
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        PrinterData[] printerDataArray = new PrinterData[printServiceArray.length];
        for (int i = 0; i < printerDataArray.length; ++i) {
            printerDataArray[i] = Printer.toPrinterData(printServiceArray[i]);
        }
        return printerDataArray;
    }

    public static PrinterData getDefaultPrinterData() {
        return Printer.toPrinterData(PrintServiceLookup.lookupDefaultPrintService());
    }

    public static PrinterData toPrinterData(PrintService printService) {
        PrinterData printerData = new PrinterData();
        if (printService != null) {
            printerData.name = printService.getName();
            printerData.driver = "Virtual";
            printerData.printToFile = false;
        }
        return printerData;
    }

    public PrintService getPrintService() {
        PrintService[] printServiceArray;
        if (this.getPrinterData() != null && this.getPrinterData().name != null) {
            printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
            for (int i = 0; i < printServiceArray.length; ++i) {
                if (!printServiceArray[i].getName().equals(this.getPrinterData().name)) continue;
                return printServiceArray[i];
            }
        }
        if (this.printJob == null && (printServiceArray = PrintServiceLookup.lookupDefaultPrintService()) != null) {
            return printServiceArray;
        }
        return null;
    }

    public boolean startJob(String string) {
        this.jobName = string;
        PrintService printService = this.getPrintService();
        if (printService != null) {
            this.printJob = printService.createPrintJob();
        }
        return this.printJob != null;
    }

    public void endJob() {
        try {
            if (this.printJob != null) {
                PrintableImpl printableImpl = new PrintableImpl(this.document);
                DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
                HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
                hashPrintRequestAttributeSet.add(new Copies(this.printerData.copyCount));
                if (this.printerData.scope == 1) {
                    this.printerData.startPage = this.printerData.startPage <= 0 ? 1 : this.printerData.startPage;
                    this.printerData.startPage = this.printerData.startPage > this.document.count() ? this.document.count() : this.printerData.startPage;
                    this.printerData.endPage = this.printerData.endPage < this.printerData.startPage ? this.printerData.startPage : this.printerData.endPage;
                    this.printerData.endPage = this.printerData.endPage > this.document.count() ? this.document.count() : this.printerData.endPage;
                    hashPrintRequestAttributeSet.add(new PageRanges(this.printerData.startPage, this.printerData.endPage));
                }
                if (this.printerData.printToFile && this.printerData.fileName != null && this.printerData.fileName.length() > 0) {
                    hashPrintRequestAttributeSet.add(new Destination(new URI(this.printerData.fileName)));
                }
                SimpleDoc simpleDoc = new SimpleDoc(printableImpl, sERVICE_FORMATTED, null);
                this.printJob.print(simpleDoc, hashPrintRequestAttributeSet);
            }
        }
        catch (PrintException printException) {
            printException.printStackTrace();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        this.printJob = null;
    }

    public void cancelJob() {
        this.document.clear();
        this.printJob = null;
    }

    public boolean startPage() {
        return this.printJob != null;
    }

    public void endPage() {
        this.document.makePage(this.getImage().getImageData());
    }

    public Point getDPI() {
        return new Point(0, 0);
    }

    public Rectangle getBounds() {
        return this.getImage().getBounds();
    }

    public Rectangle getClientArea() {
        return this.getImage().getBounds();
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        return new Rectangle(0, 0, 0, 0);
    }

    public PrinterData getPrinterData() {
        return this.printerData;
    }

    public void dispose() {
        this.image.dispose();
        super.dispose();
    }
}

