/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.keybindings.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.keybindings.KeyBinding;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyBindingWriter {
    private static final String SHORTCUTS_TAG = "shortcuts";
    private static final String SHORTCUT_TAG = "shortcut";
    private static final String ACTION_ATTRIBUTE = "action";
    private static final String KEYS_ATTRIBUTE = "keys";

    public static void setBindings(Set set, String string) {
        File file = new File(string);
        Document document = KeyBindingWriter.createDocument();
        KeyBindingWriter.setBindings(set, document);
        KeyBindingWriter.saveDocument(document, file);
    }

    public static Document createDocument() {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        return document;
    }

    public static void saveDocument(Document document, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(fileOutputStream);
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, streamResult);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    private static void setBindings(Set set, Document document) {
        Element element = document.createElement(SHORTCUTS_TAG);
        for (KeyBinding keyBinding : set) {
            String string = keyBinding.toString();
            String string2 = TuxGuitar.instance().getkeyBindingManager().getActionForKeyBinding(keyBinding).getName();
            Element element2 = document.createElement(SHORTCUT_TAG);
            element.appendChild(element2);
            Attr attr = document.createAttribute(KEYS_ATTRIBUTE);
            Attr attr2 = document.createAttribute(ACTION_ATTRIBUTE);
            attr.setNodeValue(string);
            attr2.setNodeValue(string2);
            element2.getAttributes().setNamedItem(attr);
            element2.getAttributes().setNamedItem(attr2);
        }
        document.appendChild(element);
    }
}

