/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.keybindings;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Composite;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.keybindings.KeyBinding;
import org.herac.tuxguitar.gui.keybindings.KeyBindingDefaults;
import org.herac.tuxguitar.gui.keybindings.xml.KeyBindingReader;
import org.herac.tuxguitar.gui.keybindings.xml.KeyBindingWriter;

public class KeyBindingManager {
    private static KeyBindingManager instance;
    private Map keyBindings = new HashMap();
    private KeyBindingListener kbl;

    public void init() {
        Map map = KeyBindingReader.getKeyBindings(this.getUserFileName());
        if (map != null) {
            this.keyBindings.putAll(map);
        } else {
            map = KeyBindingDefaults.getDefaultKeyBindings();
            this.keyBindings.putAll(map);
            this.saveKeyBindings();
        }
        this.kbl = new KeyBindingListener();
    }

    private String getUserFileName() {
        return TuxGuitar.getUserConfigDir() + File.separator + "keybindings.xml";
    }

    public Action getActionForKeyBinding(KeyBinding keyBinding) {
        return (Action)this.keyBindings.get(keyBinding);
    }

    public void removeAction(KeyBinding keyBinding) {
        this.keyBindings.remove(keyBinding);
    }

    public void reset(Map map) {
        this.keyBindings.clear();
        this.keyBindings.putAll(map);
    }

    public Set getKeyBindings() {
        return this.keyBindings.keySet();
    }

    public void saveKeyBindings() {
        KeyBindingWriter.setBindings(this.getKeyBindings(), this.getUserFileName());
    }

    public void appendListenersTo(Composite composite) {
        composite.addKeyListener((KeyListener)this.kbl);
    }

    class KeyBindingListener
    implements KeyListener {
        KeyBindingListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            KeyBinding keyBinding = new KeyBinding();
            keyBinding.setKey(keyEvent.keyCode);
            keyBinding.setMask(keyEvent.stateMask);
            Action action = (Action)KeyBindingManager.this.keyBindings.get(keyBinding);
            if (action != null) {
                action.process((TypedEvent)keyEvent);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

