/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ItemContainer;

public class EditToolItems
implements ItemContainer {
    public static final String NAME = "EDIT_ITEMS";
    private TablatureEditor tablatureEditor;
    private ToolBar toolBar;
    private ToolItem undo;
    private ToolItem redo;

    public EditToolItems(TablatureEditor tablatureEditor, ToolBar toolBar) {
        this.tablatureEditor = tablatureEditor;
        this.toolBar = toolBar;
    }

    public void showItems() {
        this.undo = new ToolItem(this.toolBar, 8);
        this.undo.setImage(SystemImages.UNDO_IMAGE);
        this.undo.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("UNDO"));
        this.redo = new ToolItem(this.toolBar, 8);
        this.redo.setImage(SystemImages.REDO_IMAGE);
        this.redo.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("REDO"));
        this.loadProperties();
    }

    public void update() {
        this.undo.setEnabled(this.tablatureEditor.getUndoManager().canUndo());
        this.redo.setEnabled(this.tablatureEditor.getUndoManager().canRedo());
    }

    public void loadProperties() {
        this.undo.setToolTipText(TuxGuitar.getProperty("edit.undo"));
        this.redo.setToolTipText(TuxGuitar.getProperty("edit.redo"));
    }
}

