/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.config.Defaults;

public class SystemConfigManager {
    private Properties properties = new Properties(new Defaults().getProperties());

    public void init() {
        this.load();
    }

    private String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public String getStringConfigValue(String string) {
        return this.getProperty(string);
    }

    public int getIntConfigValue(String string) {
        String string2 = this.getProperty(string);
        return Integer.parseInt(string2);
    }

    public boolean getBooleanConfigValue(String string) {
        String string2 = this.getProperty(string);
        return Boolean.valueOf(string2);
    }

    public void setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    public void setProperty(String string, int n) {
        this.setProperty(string, Integer.toString(n));
    }

    public void setProperty(String string, boolean bl) {
        this.setProperty(string, Boolean.toString(bl));
    }

    public void clear() {
        this.properties.clear();
    }

    public void load() {
        try {
            if (new File(this.getFileName()).exists()) {
                FileInputStream fileInputStream = new FileInputStream(this.getFileName());
                this.properties.clear();
                this.properties.load(fileInputStream);
            } else {
                this.save();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void save() {
        try {
            this.properties.store(new FileOutputStream(this.getFileName()), "System Configuration");
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String getFileName() {
        return TuxGuitar.getUserConfigDir() + File.separator + "config.properties";
    }
}

