/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.note;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureComponent;
import org.herac.tuxguitar.gui.tab.NoteCoords;
import org.herac.tuxguitar.gui.undo.undoables.component.UndoableComponentGeneric;

public class ChangeTiedNoteAction
extends Action {
    public static final String NAME = "CHANGE_TIED_NOTE";

    public ChangeTiedNoteAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        Caret caret = this.getEditor().getTablature().getCaret();
        MeasureComponent measureComponent = caret.getMeasureCoords().getComponent(caret.getPosition(), caret.getSelectedString().getNumber());
        if (measureComponent instanceof NoteCoords) {
            UndoableComponentGeneric undoableComponentGeneric = UndoableComponentGeneric.startUndo();
            NoteCoords noteCoords = (NoteCoords)measureComponent;
            this.getSongManager().getMeasureManager().changeTieNote(noteCoords.getNote());
            this.getEditor().getUndoManager().addEdit(undoableComponentGeneric.endUndo());
        }
        this.updateTablature();
        return true;
    }

    protected void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
        this.redraw();
    }
}

