/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.measure;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.clipboard.CannotInsertTransferException;
import org.herac.tuxguitar.gui.clipboard.MeasureTransferable;
import org.herac.tuxguitar.gui.clipboard.Transferable;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;

public class PasteMeasureAction
extends Action {
    public static final String NAME = "PASTE_MEASURE";
    private int pasteMode;

    public PasteMeasureAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        this.pasteMode = 1;
        this.showDialog(this.getEditor().getTablature().getShell());
        return true;
    }

    public void showDialog(Shell shell) {
        SongTrackCoords songTrackCoords = this.getEditor().getTablature().getCaret().getSongTrackCoords();
        MeasureCoords measureCoords = this.getEditor().getTablature().getCaret().getMeasureCoords();
        if (measureCoords != null) {
            final Shell shell2 = new Shell(shell, 67680);
            shell2.setLayout((Layout)new GridLayout());
            shell2.setText(TuxGuitar.getProperty("edit.paste"));
            Composite composite = new Composite((Composite)shell2, 0);
            composite.setLayout((Layout)new GridLayout());
            final Button button = new Button(composite, 16);
            button.setText(TuxGuitar.getProperty("edit.paste.replace-mode"));
            final Button button2 = new Button(composite, 16);
            button2.setText(TuxGuitar.getProperty("edit.paste.insert-mode"));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (button.getSelection()) {
                        PasteMeasureAction.this.pasteMode = 1;
                    }
                }
            });
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (button2.getSelection()) {
                        PasteMeasureAction.this.pasteMode = 2;
                    }
                }
            });
            button.setSelection(true);
            Composite composite2 = new Composite((Composite)shell2, 0);
            composite2.setLayout((Layout)new GridLayout(2, false));
            composite2.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
            Button button3 = new Button(composite2, 8);
            button3.setText(TuxGuitar.getProperty("ok"));
            button3.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
            button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    PasteMeasureAction.this.pasteMeasures();
                    shell2.dispose();
                }
            });
            Button button4 = new Button(composite2, 8);
            button4.setText(TuxGuitar.getProperty("cancel"));
            button4.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
            button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.pack();
            shell2.open();
            int n = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
            int n2 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
            shell2.setLocation(n, n2);
            while (!shell2.isDisposed()) {
                if (shell2.getDisplay().readAndDispatch()) continue;
                shell2.getDisplay().sleep();
            }
        }
    }

    private void pasteMeasures() {
        try {
            Transferable transferable = this.getEditor().getClipBoard().getTransferable();
            if (transferable instanceof MeasureTransferable) {
                Caret caret = this.getEditor().getTablature().getCaret();
                ((MeasureTransferable)transferable).setTransferType(this.pasteMode);
                transferable.insertTransfer();
                this.updateTablature();
                this.redraw();
            }
        }
        catch (CannotInsertTransferException cannotInsertTransferException) {
            cannotInsertTransferException.printStackTrace();
        }
    }
}

