/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.MemoryHelper;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.io.gp.GPFormatException;

public class OpenFileAction
extends Action {
    public static final String NAME = "OPEN_FILE";

    public OpenFileAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        this.getEditor().getSongManager().getPlayer().reset();
        Shell shell = this.getEditor().getTablature().getShell();
        MemoryHelper memoryHelper = this.getEditor().getMemoryHelper();
        String[] stringArray = new String[]{"Suported Files (*.tg,*.gp3,*.gp4,*.gp5)"};
        String[] stringArray2 = new String[]{"*.tg;*.gp3;*.gp4;*.gp5"};
        FileChooser fileChooser = new FileChooser(shell, stringArray, stringArray2, memoryHelper.getLastChooserPath(), memoryHelper.getFileName());
        final String string = fileChooser.show(4098);
        if (string != null) {
            this.getEditor().getTablature().changeCursor(1);
            new Thread(new Runnable(){

                public void run() {
                    try {
                        OpenFileAction.this.getEditor().getSongManager().open(string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        OpenFileAction.this.showErrorMessage(string);
                        fileNotFoundException.printStackTrace();
                    }
                    catch (GPFormatException gPFormatException) {
                        OpenFileAction.this.showErrorMessage(string);
                        gPFormatException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        OpenFileAction.this.showErrorMessage(string);
                        iOException.printStackTrace();
                    }
                    OpenFileAction.this.getEditor().notifyMemoryHelper(string);
                    new SyncThread(new Runnable(){

                        public void run() {
                            if (!TuxGuitar.isDisposed()) {
                                OpenFileAction.this.getEditor().resetDefaults();
                                TuxGuitar.instance().getMixer().update();
                                TuxGuitar.instance().getTableViewer().getTableInfo().fireUpdate();
                                OpenFileAction.this.redraw();
                                OpenFileAction.this.getEditor().getTablature().changeCursor(0);
                            }
                        }
                    }).start();
                }
            }).start();
        }
        return true;
    }

    private void showErrorMessage(final String string) {
        new SyncThread(new Runnable(){

            public void run() {
                if (!TuxGuitar.isDisposed()) {
                    OpenFileAction.this.getEditor().getTablature().changeCursor(0);
                    String string3 = "Error Message";
                    String string2 = "Cannot Open file: " + string;
                    new MessageDialog(string3, string2, 33).show(OpenFileAction.this.getEditor().getTablature().getShell());
                }
            }
        }).start();
    }
}

