package org.herac.tuxguitar.gui.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;

public class ConfirmDialog {
	private Shell parent;
	private String message;
	private boolean confirm;

	public ConfirmDialog(Shell parent,String message){
		this.parent = parent;
		this.message = message;
		this.confirm = false;
	}
	
	public boolean confirm(){
		final Shell dialog = new Shell(this.parent, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
		dialog.setLayout(new GridLayout(1, true));
		
		
		//========================================================================
		Composite labelComposite = new Composite(dialog, SWT.NONE);
		labelComposite.setLayout(new GridLayout(2, false));

		Label icon = new Label(labelComposite, SWT.NONE);
        Label message = new Label(labelComposite, SWT.NONE);
        icon.setImage(parent.getDisplay().getSystemImage(SWT.ICON_QUESTION));
        message.setText(this.message);
		
		
        //========================================================================
		Composite buttonComposite = new Composite(dialog, SWT.NONE);
		buttonComposite.setLayout(new GridLayout(2, false));
		buttonComposite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
		
		
        Button buttonCancel = new Button(buttonComposite, SWT.PUSH);            
        buttonCancel.setText(TuxGuitar.getProperty("no"));
        buttonCancel.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
                confirm = false;
            }
        });
		
        Button buttonOk = new Button(buttonComposite, SWT.PUSH);            
        buttonOk.setText(TuxGuitar.getProperty("yes"));
        buttonOk.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
                confirm = true;
            }
        });

		
        dialog.pack();
        dialog.open();

        int x = this.parent.getBounds().x + (this.parent.getBounds().width - dialog.getSize().x) / 2;
        int y = this.parent.getBounds().y + (this.parent.getBounds().height - dialog.getSize().y) / 2;
        dialog.setLocation(x, y);
        
        
        
		
		while (!dialog.isDisposed()) {
            if (!dialog.getDisplay().readAndDispatch()) {
            	dialog.getDisplay().sleep();
            }

        }
		
		return this.confirm;
		
	}

}
