package org.herac.tuxguitar.gui.undo.undoables.track;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.TrackColor;

public class UndoableInfoTrack implements UndoableEdit{
	private int doAction;
	private UndoableCaretHelper undoCaret;
	private UndoableCaretHelper redoCaret;	
	private long trackNumber;
	private String undoName;
	private String redoName;
	private TrackColor undoColor;
	private TrackColor redoColor;
	
	private UndoableInfoTrack(){
		
	}
	
	public void redo() throws CannotRedoException {	
		if(!canRedo()){
			throw new CannotRedoException();
		}   
		SongManager manager = TuxGuitar.instance().getSongManager();
		manager.getTrackManager().changeInfo(manager.getTrack(trackNumber),redoName,(TrackColor)redoColor.clone());
		TuxGuitar.instance().fireUpdate();
		TuxGuitar.instance().getMixer().update();
		this.redoCaret.update();		
		this.doAction = UNDO_ACTION;
	}

	public void undo() throws CannotUndoException {
		if(!canUndo()){
			throw new CannotUndoException();
		}					
		SongManager manager = TuxGuitar.instance().getSongManager();
		manager.getTrackManager().changeInfo(manager.getTrack(trackNumber),undoName,(TrackColor)undoColor.clone());
		TuxGuitar.instance().fireUpdate();
		TuxGuitar.instance().getMixer().update();
		this.undoCaret.update();
		
		this.doAction = REDO_ACTION;
	}

    public boolean canRedo() {
        return (doAction == REDO_ACTION);
    }

    public boolean canUndo() {
        return (doAction == UNDO_ACTION);
    }
      
    public static UndoableInfoTrack startUndo(SongTrack track){
    	UndoableInfoTrack undoable = new UndoableInfoTrack();
    	Caret caret = getCaret();    	    	
    	undoable.doAction = UNDO_ACTION;
    	undoable.trackNumber = track.getNumber();
    	undoable.undoCaret = new UndoableCaretHelper();	    	    	    	
    	undoable.undoName = track.getName();
    	undoable.undoColor = (TrackColor)track.getColor().clone();
    	
    	return undoable;
    }
    
    public UndoableInfoTrack endUndo(SongTrack track){
    	this.redoCaret = new UndoableCaretHelper();	    	    	
    	this.redoName = track.getName();
    	this.redoColor = (TrackColor)track.getColor().clone();
    	
    	return this;
    }
    
    private static Caret getCaret(){
    	return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }  

}
