package org.herac.tuxguitar.gui.undo.undoables.measure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.SongCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.Measure;

public class UndoableInsertMeasure implements UndoableEdit{
	private int doAction;
	private UndoableCaretHelper undoCaret;
	private UndoableCaretHelper redoCaret;		
	private long insertPosition;
	private List undoableMeasures;
	private int undoableNumber;
	private int copyCount;
	
	public UndoableInsertMeasure(){
    	Caret caret = getCaret();    	    	
    	this.doAction = UNDO_ACTION;
    	this.undoCaret = new UndoableCaretHelper();	    	    	
    	this.insertPosition = caret.getPosition();
    	this.undoableNumber = caret.getMeasureCoords().getMeasure().getNumber();
    	this.undoableMeasures = new ArrayList();
	}
	
	public void redo() throws CannotRedoException {	
		if(!canRedo()){
			throw new CannotRedoException();
		}   
		SongCoords songCoords = getCaret().getSongCoords();	
		Iterator it = this.undoableMeasures.iterator();
		while(it.hasNext()){
			UndoableMeasures undoable = (UndoableMeasures)it.next();		
			SongTrackCoords currTrackCoords = songCoords.getTrack(undoable.getTrackNumber());				
			songCoords.getSongManager().getTrackManager().insertMeasures(currTrackCoords.getTrack(),undoable.getMeasures(),undoableNumber);
		}

		TuxGuitar.instance().fireUpdate();
		this.redoCaret.update();	
		
		this.doAction = UNDO_ACTION;
	}

	public void undo() throws CannotUndoException {
		if(!canUndo()){
			throw new CannotUndoException();
		}							
		for(int i = 0;i < this.copyCount;i ++){
			TuxGuitar.instance().getSongManager().removeMeasure(insertPosition);
		}
		TuxGuitar.instance().fireUpdate();
		this.undoCaret.update();
		
		this.doAction = REDO_ACTION;
	}

    public boolean canRedo() {
        return (doAction == REDO_ACTION);
    }

    public boolean canUndo() {
        return (doAction == UNDO_ACTION);
    }
      
    public void addUndo(long trackNumber, List measures){
    	undoableMeasures.add(new UndoableMeasures(trackNumber,measures));
    }
    
    public UndoableInsertMeasure endUndo(int copyCount){
    	this.redoCaret = new UndoableCaretHelper();
    	this.copyCount = copyCount;
    	return this;
    }
    
    private static Caret getCaret(){
    	return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }  
    
    private class UndoableMeasures{
    	private long trackNumber;
    	private List measures;

    	public UndoableMeasures(long trackNumber, List measures) {
			this.trackNumber = trackNumber;
			this.measures = cloneMeasures(measures);
		}

		public List getMeasures() {
			return cloneMeasures(this.measures);
		}
		
		public long getTrackNumber() {
			return trackNumber;
		}
		
		private List cloneMeasures(List measures){
			List clones = new ArrayList();
			Iterator it = measures.iterator();
			while(it.hasNext()){
				Measure measure = (Measure)it.next();
				clones.add(measure.clone());
			}
			return clones;
		}
    	
    }
}
