/*
 * Created on 20-mar-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.mixer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class SongMixer {
	private Shell dialog;
	private SongVolume songVolume;
	private List trackMixers;	
	
	public static void main(String[] s) {
		new SongMixer();
	}

	public SongMixer() {
		this.trackMixers = new ArrayList();
	}

	public void show() {
		Shell shell = TuxGuitar.instance().getTablatureEditor().getTablature().getShell();
		this.dialog = new Shell(shell, SWT.DIALOG_TRIM);

		this.loadData();
		
		this.dialog.open();

		int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
		int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
		dialog.setLocation(x, y);
		
		TuxGuitar.instance().getItemContainerManager().updateItems();
		while (!dialog.isDisposed()) {
			if (!dialog.getDisplay().readAndDispatch()) {
				dialog.getDisplay().sleep();
			}
		}		
		TuxGuitar.instance().getItemContainerManager().updateItems();
	}
	
	public void update(){
		if(!isDisposed()){
			this.clear();
			this.loadData();
			this.dialog.layout();
		}
	}
	
	
	private void loadData(){		
		this.trackMixers.clear();
		List tracks = TuxGuitar.instance().getTablatureEditor().getSongManager().getSong().getTracks();
		Iterator it = tracks.iterator();
		while (it.hasNext()) {
			SongTrack track = (SongTrack) it.next();
			TrackMixer trackMixer = new TrackMixer(this,track);
			trackMixer.init(dialog);
			trackMixers.add(trackMixer);
		}
		this.songVolume = new SongVolume(TuxGuitar.instance().getSongManager());
		this.songVolume.init(this.dialog);
		
		this.loadProperties();
		
		this.dialog.setLayout(new GridLayout(dialog.getChildren().length, true));
		this.dialog.pack();		
	}
		
	private void clear(){
        Control[] controls = dialog.getChildren();
        for(int i = 0;i < controls.length;i++){
            controls[i].dispose();
        }
	}
	
	public void dispose() {
		this.dialog.dispose();
	}

	public boolean isDisposed() {
		return (this.dialog == null || this.dialog.isDisposed());
	}

	
	public void fireChanges(SongChannel channel){
		Iterator it = this.trackMixers.iterator();
		while(it.hasNext()){
			TrackMixer mixer = (TrackMixer)it.next();
			if(mixer.getTrack().getChannel().getChannel() == channel.getChannel()){
				mixer.getTrack().getChannel().setVolume(channel.getVolume());
				mixer.getTrack().getChannel().setBalance(channel.getBalance());
				mixer.getTrack().getChannel().setChorus(channel.getChorus());
				mixer.getTrack().getChannel().setReverb(channel.getReverb());
				mixer.getTrack().getChannel().setPhaser(channel.getPhaser());
				mixer.getTrack().getChannel().setTremolo(channel.getTremolo());
				mixer.getTrack().getChannel().setSolo(channel.isSolo());
				mixer.getTrack().getChannel().setMute(channel.isMute());				
				
				mixer.fireChanges();
			}else if(channel.isSolo()){
				mixer.getTrack().getChannel().setSolo(false);
				mixer.fireChanges();
			}
		}
		if (TuxGuitar.instance().getTablatureEditor().getSongManager().getPlayer().isRunning()) {
			TuxGuitar.instance().getTablatureEditor().getSongManager().getPlayer().updateChannels();			
		}		
	}

	
	public void loadProperties(){
		if(!isDisposed()){
			Iterator it = this.trackMixers.iterator();
			while(it.hasNext()){
				TrackMixer mixer = (TrackMixer)it.next();
				mixer.loadProperties();
			}
			this.songVolume.loadProperties();
			
			this.dialog.layout();
		}
	}
}
