/*
 * Created on 09-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.herac.tuxguitar.gui.TuxGuitar;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class SystemConfigManager {
    private Properties properties;  
    
    public SystemConfigManager() {
        this.properties = new Properties(new Defaults().getProperties());                 
    }

    public void init(){    	
    	this.load();
    }
    
    private String getProperty(String key) {      
        return this.properties.getProperty(key);    
    }    

    public String getStringConfigValue(String key) {
        return getProperty(key);
    }
    
    public int getIntConfigValue(String key) {
        String value = getProperty(key);
        return Integer.parseInt(value);
    }   
    
    public boolean getBooleanConfigValue(String key) {
        String value = getProperty(key);
        return Boolean.valueOf(value).booleanValue();
    }   

    public void setProperty(String key,String value){
        this.properties.setProperty(key,value);
    }
    
    public void setProperty(String key,int value){
        setProperty(key,Integer.toString(value));
    }
    
    public void setProperty(String key,boolean value){
        setProperty(key,Boolean.toString(value));
    }
    
    public void clear(){
        this.properties.clear();
    }
    
    public void load() {       
        try {                    
        	if(new File(getFileName()).exists()){        	
        		InputStream inputStream = new FileInputStream(getFileName());                        
        		this.properties.clear();
        		this.properties.load(inputStream);
        	}else{
        		this.save();
        	}
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    public void save(){
        try {
            properties.store(new FileOutputStream(getFileName()),"System Configuration");
        } catch (FileNotFoundException e1) {
            e1.printStackTrace();
        } catch (IOException e1) {
            e1.printStackTrace();
        }
    }
    
    private String getFileName(){
    	return TuxGuitar.getUserConfigDir() + File.separator + "config.properties";
    }

}