/*
 * Created on 09-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.clipboard;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.undo.undoables.JoinedUndoable;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableAddMeasure;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableChangeMeasure;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableInsertMeasure;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class MeasureTransferable implements Transferable {
	public static final int TRANSFER_TYPE_REPLACE = 1;
	public static final int TRANSFER_TYPE_INSERT = 2;
	
    private TablatureEditor tablatureEditor;
    private List trackMeasures;
    private long copyPosition;
    private int transferType;

    public MeasureTransferable(TablatureEditor tablatureEditor, long p1, long p2,boolean allTracks) {
        this.tablatureEditor = tablatureEditor;
        this.trackMeasures = new ArrayList();
        this.copyPosition = p1;
        this.transferType = TRANSFER_TYPE_REPLACE;
        this.getTransfer(p1, p2,allTracks);
    }

    private void getTransfer(long p1, long p2,boolean allTracks) {        
        if(allTracks){
        	Iterator it = tablatureEditor.getTablature().getCaret().getSongCoords().getTrackCoords().iterator();
        	while(it.hasNext()){
        		SongTrackCoords trackCoords = (SongTrackCoords)it.next();
        		List measures = tablatureEditor.getSongManager().getTrackManager().copyMeasures(trackCoords.getTrack(),p1,p2);
        		this.trackMeasures.add(new TrackMeasures(trackCoords.getTrack().getNumber(),measures));
        	}
        }else{
        	SongTrackCoords trackCoords = tablatureEditor.getTablature().getCaret().getSongTrackCoords();
        	List measures = tablatureEditor.getSongManager().getTrackManager().copyMeasures(trackCoords.getTrack(),p1,p2);
        	this.trackMeasures.add(new TrackMeasures(trackCoords.getTrack().getNumber(),measures));
        }
    }
    
    public void insertTransfer() throws CannotInsertTransferException {
        if(this.transferType == TRANSFER_TYPE_REPLACE){
        	replaceMeasures();
        }else if(this.transferType == TRANSFER_TYPE_INSERT){
        	insertMeasures();
        }
    }
    
    public void insertMeasures() throws CannotInsertTransferException {
        MeasureCoords measureCoords = tablatureEditor.getTablature().getCaret().getMeasureCoords();
        SongCoords songCoords = tablatureEditor.getTablature().getCaret().getSongCoords();
        if (measureCoords == null || songCoords == null || this.trackMeasures.isEmpty()) {
            throw new CannotInsertTransferException();
        }
        //comienza el undoable
        UndoableInsertMeasure undoable = new UndoableInsertMeasure();
        
        int fromNumber = measureCoords.getMeasure().getNumber();
        long theMove = (measureCoords.getMeasure().getStart() - copyPosition);       

        Iterator it = tablatureEditor.getTablature().getSongCoords().getTrackCoords().iterator();
        while (it.hasNext()) {
            SongTrackCoords currTrackCoords = (SongTrackCoords) it.next();
            List measures = null;
                        
            Iterator trackMeasureIt = this.trackMeasures.iterator();
            while(trackMeasureIt.hasNext()){
            	TrackMeasures trackMeasures = (TrackMeasures)trackMeasureIt.next();
            	if(trackMeasures.getTrackNumber() == currTrackCoords.getTrack().getNumber()){
            		measures = trackMeasures.getMeasures();
            		break;
            	}
            }            
            if(measures == null){
            	measures = getEmptyMeasures(((TrackMeasures)this.trackMeasures.get(0)).getMeasures());
            }else{
            	 measures = tablatureEditor.getSongManager().getTrackManager().getCloneMeasures(measures);
            }
            moveStart(currTrackCoords.getTrack(),measures, theMove);
            
            //agrega los measures al undoable
            undoable.addUndo(currTrackCoords.getTrack().getNumber(),measures);
            
            tablatureEditor.getSongManager().getTrackManager().insertMeasures(currTrackCoords.getTrack(),measures, fromNumber);
        }                
        //termia el undoable
        tablatureEditor.getUndoManager().addEdit(undoable.endUndo(((TrackMeasures)this.trackMeasures.get(0)).getMeasures().size()));        
    }
    
    public void replaceMeasures() throws CannotInsertTransferException {        
        MeasureCoords measureCoords = tablatureEditor.getTablature().getCaret().getMeasureCoords();
        SongTrackCoords trackCoords = tablatureEditor.getTablature().getCaret().getSongTrackCoords();
        SongCoords songCoords = tablatureEditor.getTablature().getCaret().getSongCoords();
        if (measureCoords == null || songCoords == null || this.trackMeasures.isEmpty()) {
            throw new CannotInsertTransferException();
        }
             
        //comienza el undoable
        JoinedUndoable undoable = new JoinedUndoable();
        
        //si no existen los compases los creo
        TrackMeasures first = (TrackMeasures)this.trackMeasures.get(0);        
        int count = first.getMeasures().size();
        int current = measureCoords.getMeasure().getNumber();
        int freeSpace =  (trackCoords.getMeasuresCoords().size()  - (current - 1));
        
               
        for(int i = freeSpace;i < count;i ++){
            //comienza el undoable
        	UndoableAddMeasure undoableAdd = UndoableAddMeasure.startUndo();  
        	
        	SongManager manager = songCoords.getSongManager(); 
        	manager.addNewMeasureBeforeEnd();
        	TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(trackCoords.getMeasuresCoords().size(),true);
        	
            //termia el undoable
        	long undoablePosition = manager.getTrackManager().getLastMeasure(trackCoords.getTrack()).getStart();
        	undoable.addUndoableEdit(undoableAdd.endUndo(undoablePosition));
        }

        
        //comienza el undoable
        UndoableChangeMeasure undoableChange = new UndoableChangeMeasure();
              
        long theMove = (measureCoords.getMeasure().getStart() - copyPosition);      
        
        Iterator it = this.trackMeasures.iterator();
        while(it.hasNext()){
        	TrackMeasures trackMeasures = (TrackMeasures)it.next();
        	
        	SongTrackCoords currTrack = songCoords.getTrack(trackMeasures.getTrackNumber());
        	List measures = tablatureEditor.getSongManager().getTrackManager().getCloneMeasures(trackMeasures.getMeasures());
        	moveStart(currTrack.getTrack(),measures, theMove);
        	
        	Iterator measureIt = measures.iterator();
        	while(measureIt.hasNext()){
        		Measure redoMeasure = (Measure)measureIt.next();      
        		Measure undoMeasure = TuxGuitar.instance().getSongManager().getTrackManager().getMeasureAt(currTrack.getTrack(),redoMeasure.getStart());        		
        		if(undoMeasure != null){        		
        			undoableChange.addUndo(currTrack.getTrack().getNumber(),undoMeasure,redoMeasure);     
        			
        			tablatureEditor.getSongManager().getTrackManager().replaceMeasure(currTrack.getTrack(),redoMeasure);
        		}
        	}
        }
        
        tablatureEditor.getSongManager().calculateMeasureStartWidthRepetitions();
        //termia el undoable
        undoable.addUndoableEdit(undoableChange.endUndo());
        tablatureEditor.getUndoManager().addEdit(undoable.endUndo());        
    }    
    
    private void moveStart(SongTrack track,List measures,long theMove) {
        Iterator it = measures.iterator();
        while (it.hasNext()) {
            Measure measure = (Measure) it.next();
            tablatureEditor.getSongManager().getTrackManager().moveMeasure(track,measure,theMove,0);
        }

    }

    private List getEmptyMeasures(List measures) {
        List emptyMeasures = new ArrayList();

        Iterator it = measures.iterator();
        while (it.hasNext()) {
            Measure measure = (Measure) it.next();
            int number = measure.getNumber();
            long start = measure.getStart();
            List notes = new ArrayList();
            List silences = new ArrayList();
            TimeSignature timeSignature = (TimeSignature) measure.getTimeSignature().clone();
            Tempo tempo = (Tempo) measure.getTempo().clone();
            boolean repeatStart = measure.isRepeatStart();
            int nombreOfRepetitions = measure.getNumberOfRepetitions();
            
            emptyMeasures.add(new Measure(number,start, notes, silences, timeSignature, tempo,repeatStart,nombreOfRepetitions));
        }
        return emptyMeasures;
    }
    
    public void setTransferType(int transferType){
    	this.transferType = transferType;
    }
    
    private class TrackMeasures{
    	private long trackNumber;
    	private List measures;
    	
    	public TrackMeasures(long trackNumber,List measures){
    		this.trackNumber = trackNumber;
    		this.measures = measures;
    	}

		public List getMeasures() {
			return measures;
		}

		public long getTrackNumber() {
			return trackNumber;
		}
    	    	
    }
}