/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.settings;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.config.PropertyNames;
import org.herac.tuxguitar.gui.config.SystemConfigManager;
import org.herac.tuxguitar.gui.tab.layout.ViewLayout;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class EditConfigAction extends Action{
    public static final String NAME = "EDIT_CONFIG";
    private SystemConfigManager config;
    private Shell dialog;
    private Option options[];
    
    public EditConfigAction(TablatureEditor tablatureEditor) {
        super(NAME,tablatureEditor);  
        this.config = TuxGuitar.instance().getConfig();
    }

    public boolean doAction(TypedEvent e) {
        showDialog(getEditor().getTablature().getShell());
        return true;
    }

    
    
    public void showDialog(Shell shell) {
            this.dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);           
            
            FormLayout layout = new FormLayout();
            FormData data = new FormData(320,300);
            data.top = new FormAttachment(0,0);
            data.bottom = new FormAttachment(100,0);
            data.left = new FormAttachment(0,0);
            data.right = new FormAttachment(100,0);
            
            dialog.setLayout(layout);
            dialog.setLayoutData(data);
            dialog.setText(TuxGuitar.getProperty("settings.config"));


            //-------main-------------------------------------         
            data.top = new FormAttachment(0,0);
            data.bottom = new FormAttachment(85,0);
            data.left = new FormAttachment(0,0);
            data.right = new FormAttachment(100,0);
            Composite mainComposite = new Composite(dialog,SWT.NONE);
            mainComposite.setLayout(new FormLayout());
            mainComposite.setLayoutData(data);
            createComposites(mainComposite);
            
            //-------buttons-------------------------------------                     
            data = new FormData();
            data.top = new FormAttachment(85,0);
            data.bottom = new FormAttachment(100,0);
            data.left = new FormAttachment(60,0);
            data.right = new FormAttachment(100,0);
            Composite buttonComposite = new Composite(dialog,SWT.NONE);
            buttonComposite.setLayout(new GridLayout(2,true));
            buttonComposite.setLayoutData(data);                          
            
            final Button buttonOK = new Button(buttonComposite, SWT.PUSH);
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            buttonOK.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {   
                    updateOptions();
                    dialog.dispose();
                }
            });

            Button buttonCancel = new Button(buttonComposite, SWT.PUSH);
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });

            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
        
    }
    
    
    
    
    
    
    
	private void createComposites(Composite parent) {	    
	    SashForm sashForm = new SashForm(parent, SWT.NONE);		   

	    ToolBar toolBar = new ToolBar(sashForm, SWT.VERTICAL | SWT.BORDER);
	    
	    Composite option = new Composite(sashForm,SWT.NONE);	    
	    option.setLayout(new FormLayout());
	
	    initOptions(toolBar,option);		

		select(options[0]);

		sashForm.setWeights(new int[] {1, 3});

        FormData data = new FormData();
        data.top = new FormAttachment(0,10);
        data.bottom = new FormAttachment(100,-10);
        data.left = new FormAttachment(0,10);
        data.right = new FormAttachment(100,-10);
        sashForm.setLayoutData(data);
	}
	
	private void initOptions(ToolBar toolBar,Composite parent){
	    this.options = new Option[2];
	    this.options[0] = new ViewOption(this.config,toolBar,parent);
		this.options[1] = new LanguageOption(this.config,toolBar,parent);
		
		for(int i = 0;i < this.options.length;i++){
		    this.options[i].createOption();		   
		}
	}

    private void select(Option option){
        hideAll();
        option.setVisible(true);
        dialog.layout();
    }
    
    private void hideAll(){
        for(int i = 0;i < this.options.length;i++){
            this.options[i].setVisible(false);
            this.options[i].setVisible(false);
        }
    }

    private void updateOptions(){        
        this.config.clear();
        for(int i = 0;i < this.options.length;i++){
            this.options[i].updateConfig();
            this.options[i].updateConfig();
        }
        this.config.save();
    }

    
    private abstract class Option extends SelectionAdapter{ 
        private SystemConfigManager config;
        private ToolBar toolBar;
        private Composite parent;
        private Group group;
        private ToolItem toolItem;
        
        public Option(SystemConfigManager config,ToolBar toolBar,final Composite parent){
            this.config = config;
            this.toolBar = toolBar;
            this.parent = parent;
            this.toolItem = new ToolItem(toolBar, SWT.RADIO);
            this.group = new Group(parent, SWT.SHADOW_ETCHED_IN);
        }
        
        public abstract void createOption();   
        
        public abstract void updateConfig();       
        
        public void setVisible(boolean visible){
            this.toolItem.setSelection(visible);
            this.group.setVisible(visible);            
        }
        
        protected FormData getFullData(){
            FormData data = new FormData();
            data.top = new FormAttachment(0,0);
            data.bottom = new FormAttachment(100,0);
            data.left = new FormAttachment(0,0);
            data.right = new FormAttachment(100,0);
            return data;
        }        
        
	    public void widgetSelected(SelectionEvent e) {
	        select(this);
	    }        	
	    
	    public SystemConfigManager getConfig(){
	        return this.config;
	    }
	    
	    public Group getGroup(){	        
	        return this.group;
	    }
	    
	    
	    public ToolItem getToolItem(){
	        return this.toolItem;
	    }
    }
    
    private class ViewOption extends Option{
        private static final int MIN_WIDHT = 640;
        private static final int MIN_HEIGHT = 480;
        
        private Button mixer;
        private Button fretBoard;
        private Button maximized;
        private Button multitrack;
        private Button[] layoutModes;
        private Spinner width;
        private Spinner height;
        public ViewOption(SystemConfigManager config,ToolBar toolBar,final Composite parent){
            super(config,toolBar,parent);            
        }        

        public void createOption(){		
    		getToolItem().setText(TuxGuitar.getProperty("settings.config.view"));	
    		getToolItem().setImage(new Image(getEditor().getTablature().getDisplay(), TuxGuitar.getResourcePath(this, "viewoption.gif")));
    		getToolItem().addSelectionListener(this);
    		
    		getGroup().setText(TuxGuitar.getProperty("settings.config.view"));
    		getGroup().setLayout(new GridLayout());
    		getGroup().setLayoutData(getFullData());
    		
    		Label title = new Label(getGroup(),SWT.NONE);
    		title.setText(TuxGuitar.getProperty("settings.config.view.mode"));
    		
    		GridData data = new GridData();
    		data.horizontalIndent = 20;
    		
    		this.mixer = new Button(getGroup(),SWT.CHECK);
    		this.mixer.setText(TuxGuitar.getProperty("show-mixer"));
    		this.mixer.setLayoutData(data);
    		this.mixer.setSelection(getConfig().getBooleanConfigValue(PropertyNames.SHOW_MIXER));
    		
    		this.fretBoard = new Button(getGroup(),SWT.CHECK);
    		this.fretBoard.setText(TuxGuitar.getProperty("show-fretboard"));
    		this.fretBoard.setLayoutData(data);
    		this.fretBoard.setSelection(getConfig().getBooleanConfigValue(PropertyNames.SHOW_FRETBOARD));

    		
    		this.multitrack = new Button(getGroup(),SWT.CHECK);
    		this.multitrack.setText(TuxGuitar.getProperty("layout.multitrack"));
    		this.multitrack.setLayoutData(data);
    		this.multitrack.setSelection(getConfig().getBooleanConfigValue(PropertyNames.SHOW_MULTITRACK));    		    	
    		
    		this.layoutModes = new Button[2];		
    		this.layoutModes[0] = new Button(getGroup(),SWT.RADIO); 
    		this.layoutModes[0].setText(TuxGuitar.getProperty("layout.page"));	
    		this.layoutModes[0].setLayoutData(data);
    		this.layoutModes[1] = new Button(getGroup(),SWT.RADIO); 
    		this.layoutModes[1].setText(TuxGuitar.getProperty("layout.linear"));
    		this.layoutModes[1].setLayoutData(data);
    		int currentMode = getConfig().getIntConfigValue(PropertyNames.LAYOUT_MODE);
    		switch(currentMode){
    			case ViewLayout.MODE_PAGE:
    			    this.layoutModes[0].setSelection(true);
    			    break;
    			case ViewLayout.MODE_LINEAR:
    			    this.layoutModes[1].setSelection(true);
    			    break;    			
    		}

    		
    		title = new Label(getGroup(),SWT.NONE);
    		title.setText(TuxGuitar.getProperty("settings.config.view.size"));
    		
    		this.maximized = new Button(getGroup(),SWT.CHECK);
    		this.maximized.setText(TuxGuitar.getProperty("settings.config.view.size.maximized"));
    		this.maximized.setLayoutData(data);
    		this.maximized.setSelection(getConfig().getBooleanConfigValue(PropertyNames.MAXIMIZED));    		
    		
    		Composite size = new Composite(getGroup(),SWT.NONE);
    		size.setLayout(new GridLayout(2,true));
    		
    		Label widthLabel = new Label(size,SWT.NONE);
    		widthLabel.setText(TuxGuitar.getProperty("settings.config.view.size.width"));
    		data = new GridData();
            data.horizontalIndent = 20;
            widthLabel.setLayoutData(data);
    		this.width = new Spinner(size, SWT.BORDER);    		
    		this.width.setMinimum(MIN_WIDHT);
    		this.width.setMaximum(getEditor().getTablature().getDisplay().getBounds().width);
    		this.width.setSelection(getConfig().getIntConfigValue(PropertyNames.WIDTH));  
            data = new GridData();
            data.widthHint = 25;
            this.width.setLayoutData(data);
    		
    		
            
            
    		Label heightLabel = new Label(size,SWT.NONE);
    		heightLabel.setText(TuxGuitar.getProperty("settings.config.view.size.height"));
    		data = new GridData();
            data.horizontalIndent = 20;
            heightLabel.setLayoutData(data);
    		this.height = new Spinner(size, SWT.BORDER);
    		this.height.setMinimum(MIN_HEIGHT);
    		this.height.setMaximum(getEditor().getTablature().getDisplay().getBounds().height);
    		this.height.setSelection(getConfig().getIntConfigValue(PropertyNames.HEIGHT));      		
    		data = new GridData();
            data.widthHint = 25;
            this.height.setLayoutData(data);

            width.setEnabled(!maximized.getSelection());
            height.setEnabled(!maximized.getSelection());
    		this.maximized.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent e) {
                    width.setEnabled(!maximized.getSelection());
                    height.setEnabled(!maximized.getSelection());
                }
            });
    		
    		
    		
        }                  
    
        
        public void updateConfig(){
            for(int i = 0;i < this.layoutModes.length;i++){
                if(this.layoutModes[i].getSelection()){
                    getConfig().setProperty(PropertyNames.LAYOUT_MODE,i + 1); 
                }
            }                   
            getConfig().setProperty(PropertyNames.SHOW_MULTITRACK,this.multitrack.getSelection());
            getConfig().setProperty(PropertyNames.SHOW_MIXER,this.mixer.getSelection());   
            getConfig().setProperty(PropertyNames.SHOW_FRETBOARD,this.fretBoard.getSelection());    
            
            getConfig().setProperty(PropertyNames.MAXIMIZED,this.maximized.getSelection());
            getConfig().setProperty(PropertyNames.WIDTH,this.width.getSelection());
            getConfig().setProperty(PropertyNames.HEIGHT,this.height.getSelection());
        }
        
    }    
    
    
    
    
    private class LanguageOption extends Option{
        private Button[] languages;
       
        
        public LanguageOption(SystemConfigManager config,ToolBar toolBar,final Composite parent){
            super(config,toolBar,parent);  
        }
        
        public void createOption(){		
    		getToolItem().setText(TuxGuitar.getProperty("settings.config.language"));	
    		getToolItem().setImage(new Image(getEditor().getTablature().getDisplay(), TuxGuitar.getResourcePath(this, "langoption.gif")));
    		getToolItem().addSelectionListener(this);
    		getGroup().setText(TuxGuitar.getProperty("settings.config.language"));
    		getGroup().setLayout(new GridLayout());
    		getGroup().setLayoutData(getFullData());    		
    		
    		Label title = new Label(getGroup(),SWT.NONE);
    		title.setText(TuxGuitar.getProperty("settings.config.language.choose"));
    		
    		GridData data = new GridData();
    		data.horizontalIndent = 20;
    		
    		String currenLanguage = getConfig().getStringConfigValue(PropertyNames.LANGUAGE);
    		String[] availableLanguages = TuxGuitar.instance().getLanguageManager().getLanguages();
    		this.languages = new Button[availableLanguages.length];
    		for(int i = 0;i < this.languages.length;i++){
    		    this.languages[i] = new Button(getGroup(),SWT.RADIO); 
    		    this.languages[i].setData(availableLanguages[i]);
    		    this.languages[i].setLayoutData(data);
    		    this.languages[i].setText(TuxGuitar.getProperty(availableLanguages[i]));	    		    
    			if(availableLanguages[i].equals(currenLanguage)){
    			    this.languages[i].setSelection(true);
    			}
    		}
    		
    		
        }                        
       
        public void updateConfig(){    		
            String selected = "";
    		for(int i = 0;i < this.languages.length;i++){
    		    if(this.languages[i].getSelection()){
    		        selected = (String)this.languages[i].getData();
    		    }
    		}
    		getConfig().setProperty(PropertyNames.LANGUAGE,selected);
        }
        
    }
}
