/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.measure;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.clipboard.CannotInsertTransferException;
import org.herac.tuxguitar.gui.clipboard.MeasureTransferable;
import org.herac.tuxguitar.gui.clipboard.Transferable;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class PasteMeasureAction extends Action{
    public static final String NAME = "PASTE_MEASURE";
    private int pasteMode;
    
    public PasteMeasureAction(TablatureEditor tablatureEditor) {
        super(NAME,true,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
    	pasteMode = MeasureTransferable.TRANSFER_TYPE_REPLACE;	        
	    showDialog(getEditor().getTablature().getShell());	    
        return true;
    }

    

    public void showDialog(Shell shell) {
    	SongTrackCoords track = getEditor().getTablature().getCaret().getSongTrackCoords();
        MeasureCoords measure = getEditor().getTablature().getCaret().getMeasureCoords();
        if (measure != null) {
            final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);  
            dialog.setLayout(new GridLayout());
            dialog.setText(TuxGuitar.getProperty("edit.paste"));
            

            //----------------------------------------------------------------------
            Composite radios = new Composite(dialog,SWT.NONE);
            radios.setLayout(new GridLayout());        
            
            final Button replace = new Button(radios,SWT.RADIO);
            replace.setText(TuxGuitar.getProperty("edit.paste.replace-mode"));
            
            final Button insert = new Button(radios,SWT.RADIO);
            insert.setText(TuxGuitar.getProperty("edit.paste.insert-mode"));
            
            replace.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                	if(replace.getSelection()){
                		pasteMode = MeasureTransferable.TRANSFER_TYPE_REPLACE;
                	}
                }
            });
            insert.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                	if(insert.getSelection()){
                		pasteMode = MeasureTransferable.TRANSFER_TYPE_INSERT;
                	}
                }
            });                                    
            replace.setSelection(true);
            //----------------------------------------------------------------------
            Composite buttons = new Composite(dialog,SWT.NONE);
            buttons.setLayout(new GridLayout(2,false));            
            buttons.setLayoutData(new GridData(SWT.RIGHT,SWT.CENTER,true,true));  
            
            final Button buttonOK = new Button(buttons, SWT.PUSH);
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            buttonOK.setLayoutData(new GridData(SWT.RIGHT,SWT.CENTER,true,true));
            buttonOK.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {   
                	pasteMeasures();
                    dialog.dispose();
                }
            });

            Button buttonCancel = new Button(buttons, SWT.PUSH);            
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.setLayoutData(new GridData(SWT.RIGHT,SWT.CENTER,true,true));
            buttonCancel.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });

            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
            
    		while (!dialog.isDisposed()) {
                if (!dialog.getDisplay().readAndDispatch()) {
                	dialog.getDisplay().sleep();
                }

            }	
        }
    }
 
    
    private void pasteMeasures(){
	    try {	        	    	
	    	Transferable transferable = getEditor().getClipBoard().getTransferable();
	    	if(transferable instanceof MeasureTransferable){	    	
	    		Caret caret = getEditor().getTablature().getCaret();  
	    		
	    		((MeasureTransferable)transferable).setTransferType(this.pasteMode);
	    		transferable.insertTransfer();                           
            
	    		updateTablature();	    	
	    		redraw();
	    	}
        } catch (CannotInsertTransferException ex) {                    
            ex.printStackTrace();
        }    	
    }
}
