/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.file;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.printer.PrintPreview;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.gui.tab.layout.PrinterViewLayout;
import org.herac.tuxguitar.gui.util.MessageDialog;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class PrintPreviewAction extends Action{
    public static final String NAME = "PRINT_PREVIEW";
    
    public PrintPreviewAction(TablatureEditor tablatureEditor) {
        super(NAME,true,tablatureEditor);       
    }    
    
    public boolean doAction(TypedEvent e) {
        new SyncThread(new Runnable() {
        	public void run() {    	
        		try{
        			getEditor().getTablature().changeCursor(SWT.CURSOR_WAIT);
        			PrintPreview preview = new PrintPreview(makePrintDocument());
        			getEditor().getTablature().changeCursor(SWT.CURSOR_ARROW);
        			preview.showPreview(getEditor().getTablature().getShell());    	
        		}catch(OutOfMemoryError error){
        			getEditor().getTablature().changeCursor(SWT.CURSOR_ARROW);
        			showErrorMessage(error);
        		}
        	}
        }).start();   
    	return true;	    
    }
    
	public PrintDocument makePrintDocument(){	
		Tablature tablature = new Tablature(getEditor().getTablature(),SWT.NONE);
        tablature.setSongManager(getEditor().getSongManager());        
        
        PrinterViewLayout layout = new PrinterViewLayout(tablature,getEditor().getSongManager(),false);
        tablature.initDefaults(layout);			
        tablature.updateTablature();					
        tablature.getCaret().update(getEditor().getTablature().getCaret().getSongTrackCoords().getTrack().getNumber());
        
        PrintDocument doc = layout.makeDocument();        
        tablature.dispose();        
		return doc;
	}

    private void showErrorMessage(final Error error){
        new SyncThread( new Runnable() {
            public void run() {
                if(!TuxGuitar.isDisposed()){                              
                String name = error.getClass().getName();
                String message = error.getMessage();
                new MessageDialog(name,message,SWT.ICON_ERROR | SWT.OK).show(getEditor().getTablature().getShell());
                }
            }
        }).start();        
    }
}
