/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.file;

import java.util.Iterator;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.printing.PrinterData;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.printer.PrintDialog;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.printer.PrintPage;
import org.herac.tuxguitar.gui.printer.Printer;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.gui.tab.layout.PrinterViewLayout;
import org.herac.tuxguitar.gui.util.MessageDialog;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class PrintAction extends Action{
    public static final String NAME = "PRINT";
    
    public PrintAction(TablatureEditor tablatureEditor) {
        super(NAME,true,tablatureEditor);       
    }
    
    
    public boolean doAction(TypedEvent e) {    	    	   	    		
    	PrintDialog dialog = new PrintDialog(getEditor().getTablature().getShell());
    	final PrinterData data = dialog.open();    		
        new SyncThread(new Runnable() {
        	public void run() {        		              
        		if(!TuxGuitar.isDisposed()){                    	
        			if(data != null){    	
        				getEditor().getTablature().changeCursor(SWT.CURSOR_WAIT);
                		Printer printer = new Printer(data);
                		if(printer.startJob("test")){    
                			try{                   			             
                				PrintDocument doc = makePrintDocument();
                				Iterator it = doc.getPages().iterator();
                				while(it.hasNext()){
                					PrintPage page = (PrintPage)it.next();    					    					    					
                					if(printer.startPage()){
                						Image pageImage = new Image(TuxGuitar.instance().getDisplay(),page.getData());
                						GC gc = new GC(printer);    
                						gc.fillRectangle(doc.getPageSize());    					
                						gc.drawImage(pageImage,0,0);
                						//libero memoria
                						gc.dispose();        						
                						pageImage.dispose();
                						page.setData(null);
                						
                						printer.endPage();    	    						
                					}
                				}                				                				
                				printer.endJob();
                				printer.dispose();
                			}catch(OutOfMemoryError error){
                				printer.dispose();
                            	showErrorMessage(error);                            	
                            	getEditor().getTablature().changeCursor(SWT.CURSOR_ARROW);
                            }
                				
                		}
                	}
                	getEditor().getTablature().changeCursor(SWT.CURSOR_ARROW);
        		}                
            }
        }).start();    		
	    return true;	    
    }
    
	public PrintDocument makePrintDocument(){	
		Tablature tablature = new Tablature(getEditor().getTablature(),SWT.NONE);
        tablature.setSongManager(getEditor().getSongManager());
        
        PrinterViewLayout layout = new PrinterViewLayout(tablature,getEditor().getSongManager(),false);
        tablature.initDefaults(layout);			
        tablature.updateTablature();		
        tablature.getCaret().update(getEditor().getTablature().getCaret().getSongTrackCoords().getTrack().getNumber());
        
        PrintDocument doc = layout.makeDocument();        
        tablature.dispose();        
		return doc;
	}
    
    private void showErrorMessage(final Error error){
        new SyncThread( new Runnable() {
            public void run() {
                if(!TuxGuitar.isDisposed()){                              
                	String name = error.getClass().getName();
                	String message = error.getMessage();
                	new MessageDialog(name,message,SWT.ICON_ERROR | SWT.OK).show(getEditor().getTablature().getShell());
                }
            }
        }).start();        
    }
}
