/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.song.models.Song;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ChangeInfoAction extends Action{
    public static final String NAME = "CHANGE_INFO";
    
    public ChangeInfoAction(TablatureEditor tablatureEditor) {
        super(NAME,true,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
        showDialog(getEditor().getTablature().getShell());
        return true;
    }

    
    public void showDialog(Shell shell) {
        Song song = getEditor().getSongManager().getSong();
        if (song != null) {
            final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);

            GridLayout layout = new GridLayout(2, false);
            layout.verticalSpacing = 20;      
            layout.horizontalSpacing = 10;
            layout.marginTop = 20;
            layout.marginLeft = 20;
            layout.marginRight = 20;
            dialog.setLayout(layout);            
            dialog.setText(TuxGuitar.getProperty("composition.properties"));
            
            //-------NAME------------------------------------
            Label nameLabel = new Label(dialog, SWT.NULL);
            nameLabel.setText(TuxGuitar.getProperty("composition.name"));
            
            final Text name = new Text(dialog, SWT.BORDER);
            name.setLayoutData(new GridData(200,13));
            name.setText(song.getName());
            
            //-------INTERPRET------------------------------------
            Label interpretLabel = new Label(dialog, SWT.NULL);
            interpretLabel.setText(TuxGuitar.getProperty("composition.interpret"));
            
            final Text interpret = new Text(dialog, SWT.BORDER);
            interpret.setLayoutData(new GridData(200,13));
            interpret.setText(song.getInterpret());            
            
            //-------ALBUM------------------------------------
            Label albumLabel = new Label(dialog, SWT.NULL);
            albumLabel.setText(TuxGuitar.getProperty("composition.album"));
            
            final Text album = new Text(dialog, SWT.BORDER);
            album.setLayoutData(new GridData(200,13));
            album.setText(song.getAlbum());              
            
            //-------ALBUM------------------------------------
            Label authorLabel = new Label(dialog, SWT.NULL);
            authorLabel.setText(TuxGuitar.getProperty("composition.author"));
            
            final Text author = new Text(dialog, SWT.BORDER);
            author.setLayoutData(new GridData(200,13));
            author.setText(song.getAuthor());  
            
            
            //----------------------------------------------------------------------            
            Composite buttonComposite = new Composite(dialog,SWT.NONE);
            buttonComposite.setLayout(new GridLayout(2, false));
          
            GridData buttonCompositeData = new GridData();
            buttonCompositeData.horizontalSpan = 2;
            buttonCompositeData.horizontalAlignment = SWT.RIGHT;
            buttonComposite.setLayoutData(buttonCompositeData);  
          
            
            final Button buttonOK = new Button(buttonComposite, SWT.PUSH);
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            
            buttonOK.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {      
                    setProperties(name.getText(),interpret.getText(),album.getText(),author.getText());
                    dialog.dispose();
                }
            });

            Button buttonCancel = new Button(buttonComposite, SWT.PUSH);
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });

            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
        }
    }
    
    
    private void setProperties(String name,String interpret,String album,String author){
        getEditor().getSongManager().setProperties(name,interpret,album,author);   
        redraw();
    }    

}
