/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.managers;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.Instrument;
import javax.sound.midi.Soundbank;
import org.herac.tuxguitar.io.SongLoader;
import org.herac.tuxguitar.io.SongWriter;
import org.herac.tuxguitar.io.gp.GPFormatException;
import org.herac.tuxguitar.play.models.Player;
import org.herac.tuxguitar.play.models.midiplayer.SongPlayer;
import org.herac.tuxguitar.song.managers.MeasureManager;
import org.herac.tuxguitar.song.managers.SongTrackManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.TrackColor;

public class SongManager {
    public static short MAX_CHANNELS = (short)16;
    private Song song;
    private Player player = new SongPlayer(this);
    private SongTrackManager trackManager;
    private MeasureManager measureManager;

    public SongManager() {
        this.newSong();
    }

    public void setSongName(String string) {
        this.getSong().setName(string);
    }

    public Song getSong() {
        return this.song;
    }

    public void newSong() {
        this.setSong(SongManager.makeNewSong());
    }

    public void save(String string) {
        try {
            new SongWriter(string).write(this.getSong());
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (GPFormatException gPFormatException) {
            gPFormatException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void open(String string) throws GPFormatException, IOException {
        SongLoader songLoader = new SongLoader(string);
        Song song = songLoader.load();
        if (song != null) {
            this.setSong(song);
        }
    }

    public void setSong(Song song) {
        this.song = song;
        this.player.reset();
    }

    public void setProperties(String string, String string2, String string3, String string4) {
        this.getSong().setName(string);
        this.getSong().setInterpret(string2);
        this.getSong().setAlbum(string3);
        this.getSong().setAuthor(string4);
    }

    public Player getPlayer() {
        return this.player;
    }

    public void addTrack(SongTrack songTrack) {
        this.orderTracks();
        int n = -1;
        for (int i = 0; i < this.getSong().getTracks().size(); ++i) {
            SongTrack songTrack2 = (SongTrack)this.getSong().getTracks().get(i);
            if (n == -1 && songTrack2.getNumber() == songTrack.getNumber()) {
                n = i;
            }
            if (n < 0) continue;
            songTrack2.setNumber(songTrack2.getNumber() + 1L);
        }
        if (n < 0) {
            n = this.getSong().getTracks().size();
        }
        this.getSong().getTracks().add(n, songTrack);
    }

    public void removeTrack(long l) {
        this.orderTracks();
        SongTrack songTrack = null;
        for (SongTrack songTrack2 : this.getSong().getTracks()) {
            if (songTrack == null && songTrack2.getNumber() == l) {
                songTrack = songTrack2;
                continue;
            }
            if (songTrack2.getNumber() != l + 1L) continue;
            songTrack2.setNumber(l);
            ++l;
        }
        this.getSong().getTracks().remove(songTrack);
    }

    private void orderTracks() {
        for (int i = 0; i < this.getSong().getTracks().size(); ++i) {
            SongTrack songTrack = null;
            for (int j = i; j < this.getSong().getTracks().size(); ++j) {
                SongTrack songTrack2 = (SongTrack)this.getSong().getTracks().get(j);
                if (songTrack != null && songTrack2.getNumber() >= songTrack.getNumber()) continue;
                songTrack = songTrack2;
            }
            this.getSong().getTracks().remove(songTrack);
            this.getSong().getTracks().add(i, songTrack);
        }
    }

    public SongTrack getTrack(Measure measure) {
        SongTrack songTrack = null;
        for (SongTrack songTrack2 : this.getSong().getTracks()) {
            if (!songTrack2.getMeasures().contains(measure)) continue;
            songTrack = songTrack2;
            break;
        }
        return songTrack;
    }

    public static Song makeNewSong() {
        ArrayList<SongTrack> arrayList = new ArrayList<SongTrack>();
        arrayList.add(SongManager.makeNewTrack(1L, "Track 1"));
        return new Song(arrayList);
    }

    public static SongTrack makeNewTrack(long l, String string) {
        TimeSignature timeSignature = new TimeSignature(4, new Duration(4));
        Tempo tempo = new Tempo(100);
        List list = SongManager.createDefaultInstrumentStrings();
        ArrayList<Measure> arrayList = new ArrayList<Measure>();
        arrayList.add(new Measure(1, 1000L, new ArrayList(), new ArrayList(), timeSignature, tempo, false, 0));
        return new SongTrack(l, string, new SongChannel(0, 1, 0), arrayList, list, TrackColor.RED);
    }

    public long getNextTrackNumber() {
        return this.countTracks() + 1;
    }

    public boolean isEmpty() {
        return this.song.getTracks().isEmpty();
    }

    public SongChannel getFreeChannel(short s, boolean bl) {
        return SongManager.getFreeChannel(this.getSong().getTracks(), s, bl);
    }

    public static SongChannel getFreeChannel(List list, short s, boolean bl) {
        if (bl) {
            return SongChannel.getDefaultPercusionChannel();
        }
        short s2 = -1;
        short s3 = -1;
        boolean[] blArray = SongManager.getUsedChannels(list);
        boolean[] blArray2 = SongManager.getUsedEffectChannels(list);
        for (short s4 = 0; s4 < MAX_CHANNELS; s4 = (short)(s4 + 1)) {
            if (blArray[s4] || blArray2[s4]) continue;
            s2 = s2 < 0 ? s4 : s2;
            s3 = s3 < 0 && s4 != s2 ? s4 : s3;
        }
        if (s2 < 0 || s3 < 0) {
            if (s2 >= 0) {
                s3 = s2;
            } else {
                SongChannel songChannel = ((SongTrack)list.get(list.size() - 1)).getChannel();
                return (SongChannel)songChannel.clone();
            }
        }
        return new SongChannel(s2, s3, s);
    }

    public boolean[] getUsedEffectChannels() {
        return SongManager.getUsedEffectChannels(this.getSong().getTracks());
    }

    public static boolean[] getUsedEffectChannels(List list) {
        boolean[] blArray = new boolean[MAX_CHANNELS];
        for (int i = 0; i < list.size(); ++i) {
            SongTrack songTrack = (SongTrack)list.get(i);
            blArray[songTrack.getChannel().getEffectChannel()] = true;
        }
        return blArray;
    }

    public boolean[] getUsedChannels() {
        return SongManager.getUsedChannels(this.getSong().getTracks());
    }

    public static boolean[] getUsedChannels(List list) {
        boolean[] blArray = new boolean[MAX_CHANNELS];
        for (int i = 0; i < list.size(); ++i) {
            SongTrack songTrack = (SongTrack)list.get(i);
            blArray[songTrack.getChannel().getChannel()] = true;
        }
        return blArray;
    }

    public SongChannel getUsedChannel(int n) {
        for (int i = 0; i < this.getSong().getTracks().size(); ++i) {
            SongTrack songTrack = (SongTrack)this.getSong().getTracks().get(i);
            if (n != songTrack.getChannel().getChannel()) continue;
            return (SongChannel)songTrack.getChannel().clone();
        }
        return null;
    }

    public int countTracksForChannel(int n) {
        int n2 = 0;
        for (int i = 0; i < this.getSong().getTracks().size(); ++i) {
            SongTrack songTrack = (SongTrack)this.getSong().getTracks().get(i);
            if (n != songTrack.getChannel().getChannel()) continue;
            ++n2;
        }
        return n2;
    }

    public void updateChannel(SongChannel songChannel) {
        for (int i = 0; i < this.getSong().getTracks().size(); ++i) {
            SongTrack songTrack = (SongTrack)this.getSong().getTracks().get(i);
            if (songChannel.getChannel() != songTrack.getChannel().getChannel()) continue;
            songTrack.setChannel((SongChannel)songChannel.clone());
        }
    }

    public static List createDefaultInstrumentStrings() {
        ArrayList<InstrumentString> arrayList = new ArrayList<InstrumentString>();
        arrayList.add(new InstrumentString(1, 64));
        arrayList.add(new InstrumentString(2, 59));
        arrayList.add(new InstrumentString(3, 55));
        arrayList.add(new InstrumentString(4, 50));
        arrayList.add(new InstrumentString(5, 45));
        arrayList.add(new InstrumentString(6, 40));
        return arrayList;
    }

    public static List createPercusionStrings(int n) {
        ArrayList<InstrumentString> arrayList = new ArrayList<InstrumentString>();
        for (int i = 1; i <= n; ++i) {
            arrayList.add(new InstrumentString(i, 0));
        }
        return arrayList;
    }

    public void calculateMeasureStartWidthRepetitions() {
        for (SongTrack songTrack : this.getSong().getTracks()) {
            this.calculateMeasureStartWidthRepetitions(songTrack);
        }
    }

    private void calculateMeasureStartWidthRepetitions(SongTrack songTrack) {
        boolean bl = true;
        long l = 1000L;
        long l2 = 0L;
        long l3 = 0L;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < songTrack.getMeasures().size(); ++i) {
            Measure measure = (Measure)songTrack.getMeasures().get(i);
            if (!bl || measure.getStart() + measure.getLength() > l2) {
                measure.setStartWidthRepetitions(measure.getStart() + l3);
                this.calculateNoteStartWidthRepetitions(measure, l3);
            }
            if (measure.isRepeatStart()) {
                n = i;
                l = measure.getStart();
                bl = true;
            }
            if (!bl || measure.getNumberOfRepetitions() <= 0) continue;
            if (n2 < measure.getNumberOfRepetitions()) {
                l2 = measure.getStart() + measure.getLength();
                l3 += l2 - l;
                i = n - 1;
                ++n2;
                continue;
            }
            l = 0L;
            n2 = 0;
            l2 = 0L;
            bl = false;
        }
    }

    private void calculateNoteStartWidthRepetitions(Measure measure, long l) {
        for (int i = 0; i < measure.getNotes().size(); ++i) {
            Note note = (Note)measure.getNotes().get(i);
            note.setStartWidthRepetitions(note.getStart() + l);
        }
    }

    public String getInstrumentName(int n) {
        String string = null;
        Soundbank soundbank = this.getPlayer().getDefaultSoundbank();
        if (soundbank != null) {
            Instrument[] instrumentArray = soundbank.getInstruments();
            string = instrumentArray[n].getName();
        } else {
            string = Integer.toString(n);
        }
        return string;
    }

    public int countTracks() {
        return this.getSong().getTracks().size();
    }

    public int countMeasures() {
        return this.getTrackManager().countMeasures(this.getFirstTrack());
    }

    public SongTrackManager getTrackManager() {
        if (this.trackManager == null) {
            this.trackManager = new SongTrackManager(this);
        }
        return this.trackManager;
    }

    public MeasureManager getMeasureManager() {
        if (this.measureManager == null) {
            this.measureManager = new MeasureManager(this);
        }
        return this.measureManager;
    }

    public SongTrack getTrack(long l) {
        SongTrack songTrack = null;
        for (int i = 0; i < this.getSong().getTracks().size(); ++i) {
            SongTrack songTrack2 = (SongTrack)this.getSong().getTracks().get(i);
            if (songTrack2.getNumber() != l) continue;
            songTrack = songTrack2;
            break;
        }
        return songTrack;
    }

    public SongTrack getFirstTrack() {
        SongTrack songTrack = null;
        if (!this.getSong().getTracks().isEmpty()) {
            songTrack = (SongTrack)this.getSong().getTracks().get(0);
        }
        return songTrack;
    }

    public SongTrack getLastTrack() {
        SongTrack songTrack = null;
        if (!this.getSong().getTracks().isEmpty()) {
            songTrack = (SongTrack)this.getSong().getTracks().get(this.getSong().getTracks().size() - 1);
        }
        return songTrack;
    }

    private SongTrack makeNewTrack(SongTrack songTrack) {
        ArrayList<Measure> arrayList = new ArrayList<Measure>();
        for (Measure measure : songTrack.getMeasures()) {
            int n = measure.getNumber();
            long l = measure.getStart();
            boolean bl = measure.isRepeatStart();
            int n2 = measure.getNumberOfRepetitions();
            TimeSignature timeSignature = (TimeSignature)measure.getTimeSignature().clone();
            Tempo tempo = (Tempo)measure.getTempo().clone();
            arrayList.add(new Measure(n, l, new ArrayList(), new ArrayList(), timeSignature, tempo, bl, n2));
        }
        long l = this.getNextTrackNumber();
        String string = "Track " + l;
        SongChannel songChannel = this.getFreeChannel((short)0, false);
        List list = SongManager.createDefaultInstrumentStrings();
        return new SongTrack(l, string, songChannel, arrayList, list, TrackColor.RED);
    }

    public SongTrack createTrack() {
        SongTrack songTrack = null;
        if (this.getSong().getTracks().isEmpty()) {
            long l = this.getNextTrackNumber();
            songTrack = SongManager.makeNewTrack(l, "Track " + l);
        } else {
            songTrack = this.makeNewTrack(this.getFirstTrack());
        }
        this.addTrack(songTrack);
        return songTrack;
    }

    public void removeTrack(SongTrack songTrack) {
        this.removeTrack(songTrack.getNumber());
    }

    public void changeTimeSignature(long l, TimeSignature timeSignature, boolean bl) {
        for (SongTrack songTrack : this.getSong().getTracks()) {
            this.getTrackManager().changeTimeSignature(songTrack, l, timeSignature, bl);
        }
    }

    public void changeTempo(long l, Tempo tempo, boolean bl) {
        for (SongTrack songTrack : this.getSong().getTracks()) {
            this.getTrackManager().changeTempo(songTrack, l, tempo, bl);
        }
    }

    public void changeOpenRepeat(long l) {
        for (SongTrack songTrack : this.getSong().getTracks()) {
            this.getTrackManager().changeOpenRepeat(songTrack, l);
        }
        this.calculateMeasureStartWidthRepetitions();
    }

    public void changeCloseRepeat(long l, int n) {
        for (SongTrack songTrack : this.getSong().getTracks()) {
            this.getTrackManager().changeCloseRepeat(songTrack, l, n);
        }
        this.calculateMeasureStartWidthRepetitions();
    }

    public void addNewMeasureBeforeEnd() {
        for (SongTrack songTrack : this.getSong().getTracks()) {
            this.getTrackManager().addNewMeasureBeforeEnd(songTrack);
        }
        this.calculateMeasureStartWidthRepetitions();
    }

    public void removeMeasures(long l, long l2) {
        for (SongTrack songTrack : this.getSong().getTracks()) {
            this.getTrackManager().removeMeasures(songTrack, l, l2);
        }
        this.calculateMeasureStartWidthRepetitions();
    }

    public void removeMeasure(long l) {
        for (SongTrack songTrack : this.getSong().getTracks()) {
            this.getTrackManager().removeMeasure(songTrack, l);
        }
        this.calculateMeasureStartWidthRepetitions();
    }

    public List getMeasures(long l) {
        ArrayList<Measure> arrayList = new ArrayList<Measure>();
        for (SongTrack songTrack : this.getSong().getTracks()) {
            Measure measure = this.getTrackManager().getMeasureAt(songTrack, l);
            if (measure == null) continue;
            arrayList.add(measure);
        }
        return arrayList;
    }

    public List[] copyMeasures(long l, long l2) {
        List[] listArray = new List[this.getSong().getTracks().size()];
        for (int i = 0; i < listArray.length; ++i) {
            List list;
            SongTrack songTrack = this.getTrack(i + 1);
            listArray[i] = list = this.getTrackManager().copyMeasures(songTrack, l, l2);
        }
        return listArray;
    }

    public SongTrack replaceTrack(SongTrack songTrack) {
        SongTrack songTrack2 = this.getTrack(songTrack.getNumber());
        if (songTrack2 != null) {
            songTrack2.makeEqual(songTrack);
        }
        return songTrack2;
    }
}

