/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.tab.DurationCoords;
import org.herac.tuxguitar.gui.tab.MeasureComponent;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.gui.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.models.Component;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Silence;

public class SilenceCoords
implements MeasureComponent {
    private Tablature tablature;
    private MeasureCoords meassureCoords;
    private Silence silence;
    private Image image;
    private int posX;
    private int posY;
    private DurationCoords durationCoords;
    private int span;
    private int pointX;
    private int pointY;

    public SilenceCoords(Tablature tablature, MeasureCoords measureCoords, Silence silence, int n, int n2) {
        this.tablature = tablature;
        this.meassureCoords = measureCoords;
        this.silence = silence;
        this.posX = n;
        this.posY = n2;
    }

    public void update() {
        if (this.getDuration() != null) {
            this.image = SystemImages.getSilence(this.getDuration().getValue());
        }
    }

    public void paint(ViewLayout viewLayout, GC gC, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (this.silence != null && this.image != null) {
            int n5 = this.meassureCoords.getHeight() / 2;
            n3 = this.posX + n - 10 + this.getSpan();
            n4 = n2 + (n5 - 10);
            gC.drawImage(this.image, n3, n4);
            this.pointX = n3 + 10;
            if (this.silence.getDuration().isDotted() || this.silence.getDuration().isDoubleDotted()) {
                gC.drawOval(n3 + 23, n4 + 15, 1, 1);
                if (this.silence.getDuration().isDoubleDotted()) {
                    gC.drawOval(n3 + 26, n4 + 15, 1, 1);
                }
            }
            if (!this.silence.getDuration().getTupleto().isEqual(Duration.NO_TUPLETO)) {
                gC.drawString(Integer.toString(this.silence.getDuration().getTupleto().getEnters()), n3 + 12, n4 + 81);
            }
        } else {
            n3 = this.posX + n + 3 + this.getSpan();
            n4 = this.posY + n2 + 15;
            gC.drawString("S", n3, n4);
        }
        if (viewLayout.isPlayModeEnabled() && this.isPlaying()) {
            gC.setForeground(this.tablature.getDisplay().getSystemColor(3));
            gC.drawString(">", this.posX + n + 3 + this.getSpan(), n2 + this.meassureCoords.getHeight() + 50);
            gC.setForeground(new Color((Device)this.tablature.getDisplay(), 0, 0, 0));
        }
    }

    private boolean isPlaying() {
        long l;
        return this.meassureCoords.getTrackCoords().hasCaret() && this.meassureCoords.isPlaying() && (l = this.tablature.getSongManager().getPlayer().getTickPosition()) >= this.getSilence().getStart() && l < this.getSilence().getStart() + this.getSilence().getDuration().getTime();
    }

    public void setDuration(Duration duration) {
        this.silence.setDuration(duration);
    }

    public Duration getDuration() {
        return this.silence.getDuration();
    }

    public void setStart(long l) {
        this.silence.setStart(l);
    }

    public long getStart() {
        return this.silence.getStart();
    }

    public Silence getSilence() {
        return this.silence;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getSpan() {
        return this.span;
    }

    public void setSpan(int n) {
        this.span = n;
    }

    public int getPointX() {
        return this.pointX;
    }

    public int getPointY() {
        return this.pointY;
    }

    public Component getComponent() {
        return this.getSilence();
    }
}

