/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.printer;

import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.standard.PrinterInfo;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterMakeAndModel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.FileChooser;

public class PrintDialog {
    private Shell parent;
    private Shell dialog;
    private int style;
    private PrintService[] printServices;
    private PrinterData printerData;
    private Combo servicesCombo;
    private Label servicesStatus;
    private Label servicesType;
    private Label servicesInfo;
    private Button printToFile;
    private Text filePath;
    private Button fileChooser;
    private Spinner copiesSpinner;
    private Button allPages;
    private Button rangePages;
    private Text fromRangePage;
    private Text toRangePage;

    public PrintDialog(Shell shell) {
        this(shell, 67680);
    }

    public PrintDialog(Shell shell, int n) {
        this.parent = shell;
        this.style = n;
        this.findServices();
    }

    public void findServices() {
        this.printServices = PrintServiceLookup.lookupPrintServices(null, null);
    }

    public PrinterData open() {
        this.dialog = new Shell(this.parent, this.style);
        this.dialog.setLayout((Layout)new FillLayout());
        this.dialog.setText(TuxGuitar.getProperty("print.dialog"));
        this.initComposites();
        this.dialog.pack();
        this.dialog.open();
        int n = this.parent.getBounds().x + (this.parent.getBounds().width - this.dialog.getSize().x) / 2;
        int n2 = this.parent.getBounds().y + (this.parent.getBounds().height - this.dialog.getSize().y) / 2;
        this.dialog.setLocation(n, n2);
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
        return this.printerData;
    }

    private void initComposites() {
        Composite composite = new Composite((Composite)this.dialog, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        Group group = new Group(composite2, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("print.service"));
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)group, 0);
        label.setText(TuxGuitar.getProperty("print.service.name") + ":");
        this.servicesCombo = new Combo((Composite)group, 0);
        for (int i = 0; i < this.printServices.length; ++i) {
            this.servicesCombo.add(this.printServices[i].getName());
        }
        this.servicesCombo.select(0);
        this.servicesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PrintDialog.this.checkServiceValues();
            }
        });
        Label label2 = new Label((Composite)group, 0);
        label2.setText(TuxGuitar.getProperty("print.service.status") + ":");
        this.servicesStatus = new Label((Composite)group, 0);
        this.servicesStatus.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label3 = new Label((Composite)group, 0);
        label3.setText(TuxGuitar.getProperty("print.service.type") + ":");
        this.servicesType = new Label((Composite)group, 0);
        this.servicesType.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label4 = new Label((Composite)group, 0);
        label4.setText(TuxGuitar.getProperty("print.service.info") + ":");
        this.servicesInfo = new Label((Composite)group, 0);
        this.servicesInfo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.printToFile = new Button((Composite)group, 32);
        this.printToFile.setLayoutData((Object)new GridData(1, 0x1000000, true, true, 2, 1));
        this.printToFile.setText(TuxGuitar.getProperty("print.print-to-file"));
        this.printToFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PrintDialog.this.checkPrintToFileComposites();
            }
        });
        this.filePath = new Text((Composite)group, 2048);
        this.filePath.setLayoutData((Object)new GridData(220, 16));
        this.fileChooser = new Button((Composite)group, 8);
        this.fileChooser.setText(TuxGuitar.getProperty("print.file-chooser"));
        this.fileChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PrintDialog.this.chooseFile();
            }
        });
        this.checkPrintToFileComposites();
        this.checkServiceValues();
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        Group group2 = new Group(composite3, 16);
        group2.setLayout((Layout)new GridLayout(4, false));
        group2.setLayoutData((Object)new GridData(4, 4, true, true));
        group2.setText(TuxGuitar.getProperty("print.range"));
        this.allPages = new Button((Composite)group2, 16);
        this.allPages.setText(TuxGuitar.getProperty("print.range.all-pages"));
        this.allPages.setLayoutData((Object)new GridData(0, 0, false, false, 4, 1));
        this.allPages.setSelection(true);
        this.allPages.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PrintDialog.this.checkRangeComposites();
            }
        });
        this.rangePages = new Button((Composite)group2, 16);
        this.rangePages.setText(TuxGuitar.getProperty("print.range.pages"));
        this.rangePages.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PrintDialog.this.checkRangeComposites();
            }
        });
        this.fromRangePage = new Text((Composite)group2, 2048);
        this.fromRangePage.setLayoutData((Object)new GridData(23, 10));
        Label label5 = new Label((Composite)group2, 0);
        label5.setText(TuxGuitar.getProperty("print.range.pages-to"));
        this.toRangePage = new Text((Composite)group2, 2048);
        this.toRangePage.setLayoutData((Object)new GridData(23, 10));
        this.checkRangeComposites();
        Group group3 = new Group(composite3, 16);
        group3.setLayout((Layout)new GridLayout(2, false));
        group3.setLayoutData((Object)new GridData(4, 4, true, true));
        group3.setText(TuxGuitar.getProperty("print.copies"));
        Label label6 = new Label((Composite)group3, 0);
        label6.setLayoutData((Object)new GridData(0, 0x1000000, true, true));
        label6.setText(TuxGuitar.getProperty("print.copies-number"));
        this.copiesSpinner = new Spinner((Composite)group3, 2048);
        this.copiesSpinner.setLayoutData((Object)new GridData(0, 0x1000000, true, true));
        this.copiesSpinner.setMaximum(100);
        this.copiesSpinner.setMinimum(1);
        Composite composite4 = new Composite(composite, 0);
        composite4.setLayout((Layout)new GridLayout(2, false));
        composite4.setLayoutData((Object)new GridData(131072, 4, true, true));
        Button button = new Button(composite4, 8);
        button.setText(TuxGuitar.getProperty("print.print"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PrintDialog.this.updatePrinterData();
                PrintDialog.this.dialog.dispose();
            }
        });
        Button button2 = new Button(composite4, 8);
        button2.setText(TuxGuitar.getProperty("cancel"));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PrintDialog.this.dialog.dispose();
            }
        });
    }

    private void checkServiceValues() {
        String string = new String();
        String string2 = new String();
        String string3 = new String();
        int n = this.servicesCombo.getSelectionIndex();
        if (n >= 0) {
            PrintService printService = this.printServices[n];
            PrinterIsAcceptingJobs printerIsAcceptingJobs = printService.getAttribute(PrinterIsAcceptingJobs.class);
            PrinterMakeAndModel printerMakeAndModel = printService.getAttribute(PrinterMakeAndModel.class);
            PrinterInfo printerInfo = printService.getAttribute(PrinterInfo.class);
            string = printerIsAcceptingJobs == null ? "" : ((Object)printerIsAcceptingJobs).toString();
            string2 = printerMakeAndModel == null ? "" : ((Object)printerMakeAndModel).toString();
            string3 = printerInfo == null ? "" : ((Object)printerInfo).toString();
        }
        this.servicesStatus.setText(string);
        this.servicesType.setText(string2);
        this.servicesInfo.setText(string3);
    }

    private void checkRangeComposites() {
        boolean bl = this.rangePages.getSelection();
        this.fromRangePage.setEnabled(bl);
        this.toRangePage.setEnabled(bl);
    }

    private void checkPrintToFileComposites() {
        boolean bl = this.printToFile.getSelection();
        this.filePath.setEnabled(bl);
        this.fileChooser.setEnabled(bl);
    }

    private void chooseFile() {
        FileChooser fileChooser = new FileChooser(this.dialog, null, null, null, null);
        String string = fileChooser.show(4098);
        if (string != null) {
            this.filePath.setText(string);
        }
    }

    private void updatePrinterData() {
        this.printerData = new PrinterData();
        int n = this.servicesCombo.getSelectionIndex();
        if (n >= 0) {
            this.printerData.name = this.printServices[n].getName();
        }
        this.printerData.copyCount = this.copiesSpinner.getSelection();
        this.printerData.printToFile = this.printToFile.getSelection();
        this.printerData.fileName = this.filePath.getText();
        this.printerData.scope = 0;
        if (!this.allPages.getSelection()) {
            try {
                int n2 = Integer.parseInt(this.fromRangePage.getText());
                int n3 = Integer.parseInt(this.toRangePage.getText());
                this.printerData.startPage = n2;
                this.printerData.endPage = n3;
                this.printerData.scope = 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

