/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.mixer;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.song.managers.SongManager;

public class SongVolume {
    private SongManager manager;
    private Scale volumeScale;
    private Text volumeText;
    private Label volumeLabel;

    public SongVolume(SongManager songManager) {
        this.manager = songManager;
    }

    public void init(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.volumeLabel = new Label(composite2, 0);
        this.volumeScale = new Scale(composite2, 512);
        this.volumeText = new Text(composite2, 2052);
        composite2.setLayout((Layout)new GridLayout(1, true));
        composite2.setLayoutData((Object)new GridData(1040));
        GridData gridData = new GridData(1104);
        this.volumeScale.setMaximum(10);
        this.volumeScale.setMinimum(0);
        this.volumeScale.setIncrement(1);
        this.volumeScale.setPageIncrement(1);
        this.volumeScale.setLayoutData((Object)gridData);
        gridData = new GridData(64);
        gridData.widthHint = 16;
        gridData.heightHint = 13;
        this.volumeText.setEditable(false);
        this.volumeText.setLayoutData((Object)gridData);
        this.volumeScale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SongVolume.this.manager.getSong().setVolume((short)(SongVolume.this.volumeScale.getMaximum() - SongVolume.this.volumeScale.getSelection()));
                SongVolume.this.volumeScale.setToolTipText(TuxGuitar.getProperty("song.volume") + ": " + SongVolume.this.manager.getSong().getVolume());
                SongVolume.this.volumeText.setText(Integer.toString(SongVolume.this.volumeScale.getMaximum() - SongVolume.this.volumeScale.getSelection()));
                if (TuxGuitar.instance().getTablatureEditor().getSongManager().getPlayer().isRunning()) {
                    TuxGuitar.instance().getTablatureEditor().getSongManager().getPlayer().updateChannels();
                }
            }
        });
        this.volumeScale.setSelection(this.volumeScale.getMaximum() - this.manager.getSong().getVolume());
        this.volumeText.setText(Integer.toString(this.volumeScale.getMaximum() - this.volumeScale.getSelection()));
    }

    public void loadProperties() {
        this.volumeLabel.setText(TuxGuitar.getProperty("song.volume") + ":");
        this.volumeScale.setToolTipText(TuxGuitar.getProperty("song.volume") + ": " + this.manager.getSong().getVolume());
    }
}

