/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ItemContainer;

public class PlayerToolItems
implements ItemContainer {
    public static final String NAME = "PLAYER_ITEMS";
    private TablatureEditor tablatureEditor;
    private ToolBar toolBar;
    private ToolItem stop;
    private ToolItem play;

    public PlayerToolItems(TablatureEditor tablatureEditor, ToolBar toolBar) {
        this.tablatureEditor = tablatureEditor;
        this.toolBar = toolBar;
    }

    public void showItems() {
        this.stop = new ToolItem(this.toolBar, 8);
        this.stop.setImage(SystemImages.STOP_IMAGE);
        this.stop.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("STOP_SONG"));
        this.play = new ToolItem(this.toolBar, 8);
        this.play.setImage(SystemImages.PLAY_IMAGE);
        this.play.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("PLAY_SONG"));
        this.loadProperties();
    }

    public void update() {
        boolean bl = this.tablatureEditor.getSongManager().getPlayer().isRunning();
        this.play.setEnabled(!bl);
        this.stop.setEnabled(bl);
    }

    public void loadProperties() {
        this.play.setToolTipText(TuxGuitar.getProperty("player.start"));
        this.stop.setToolTipText(TuxGuitar.getProperty("player.stop"));
    }
}

