/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ItemContainer;
import org.herac.tuxguitar.gui.tab.layout.LinearViewLayout;
import org.herac.tuxguitar.gui.tab.layout.PageViewLayout;

public class LayoutMenuItem
implements ItemContainer {
    private TablatureEditor tablatureEditor;
    private MenuItem layoutMenuItem;
    private Menu menu;
    private MenuItem showMixer;
    private MenuItem showFretBoard;
    private MenuItem pageLayout;
    private MenuItem linearLayout;
    private MenuItem multitrack;

    public LayoutMenuItem(Shell shell, Menu menu, int n, TablatureEditor tablatureEditor) {
        this.layoutMenuItem = new MenuItem(menu, n);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.showMixer = new MenuItem(this.menu, 32);
        this.showMixer.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SHOW_MIXER"));
        this.showFretBoard = new MenuItem(this.menu, 32);
        this.showFretBoard.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SHOW_FRETBOARD"));
        new MenuItem(this.menu, 2);
        this.pageLayout = new MenuItem(this.menu, 16);
        this.pageLayout.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SET_PAGE_LAYOUT"));
        this.linearLayout = new MenuItem(this.menu, 16);
        this.linearLayout.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SET_LINEAR_LAYOUT"));
        this.multitrack = new MenuItem(this.menu, 32);
        this.multitrack.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SET_MULTITRACK_VIEW"));
        this.layoutMenuItem.setMenu(this.menu);
        this.loadProperties();
    }

    public void update() {
        this.showMixer.setSelection(!TuxGuitar.instance().getMixer().isDisposed());
        this.showFretBoard.setSelection(TuxGuitar.instance().getFretBoardEditor().getFretBoard().isVisible());
        this.pageLayout.setSelection(this.tablatureEditor.getTablature().getViewLayout() instanceof PageViewLayout);
        this.linearLayout.setSelection(this.tablatureEditor.getTablature().getViewLayout() instanceof LinearViewLayout);
        this.multitrack.setSelection(this.tablatureEditor.getTablature().getViewLayout().isMultitrack());
    }

    public void loadProperties() {
        this.layoutMenuItem.setText(TuxGuitar.getProperty("layout"));
        this.showMixer.setText(TuxGuitar.getProperty("show-mixer"));
        this.showFretBoard.setText(TuxGuitar.getProperty("show-fretboard"));
        this.pageLayout.setText(TuxGuitar.getProperty("layout.page"));
        this.linearLayout.setText(TuxGuitar.getProperty("layout.linear"));
        this.multitrack.setText(TuxGuitar.getProperty("layout.multitrack"));
    }
}

