/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ItemContainer;

public class CompositionMenuItem
implements ItemContainer {
    private TablatureEditor tablatureEditor;
    private MenuItem compositionMenuItem;
    private Menu menu;
    private MenuItem timeSignature;
    private MenuItem tempo;
    private MenuItem properties;

    public CompositionMenuItem(Shell shell, Menu menu, int n, TablatureEditor tablatureEditor) {
        this.compositionMenuItem = new MenuItem(menu, n);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.timeSignature = new MenuItem(this.menu, 8);
        this.timeSignature.setImage(SystemImages.TIME_SIGNATURE_IMAGE);
        this.timeSignature.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("CHANGE_TIME_SIGNATURE"));
        this.tempo = new MenuItem(this.menu, 8);
        this.tempo.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("CHANGE_TEMPO"));
        new MenuItem(this.menu, 2);
        this.properties = new MenuItem(this.menu, 8);
        this.properties.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("CHANGE_INFO"));
        this.compositionMenuItem.setMenu(this.menu);
        this.loadProperties();
    }

    public void update() {
    }

    public void loadProperties() {
        this.compositionMenuItem.setText(TuxGuitar.getProperty("composition"));
        this.timeSignature.setText(TuxGuitar.getProperty("composition.timesignature"));
        this.tempo.setText(TuxGuitar.getProperty("composition.tempo"));
        this.properties.setText(TuxGuitar.getProperty("composition.properties"));
    }
}

