/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.items.ItemContainer;
import org.herac.tuxguitar.gui.items.menu.CompositionMenuItem;
import org.herac.tuxguitar.gui.items.menu.DurationMenuItem;
import org.herac.tuxguitar.gui.items.menu.FileMenuItem;
import org.herac.tuxguitar.gui.items.menu.HelpMenuItem;
import org.herac.tuxguitar.gui.items.menu.LanguageMenuItem;
import org.herac.tuxguitar.gui.items.menu.LayoutMenuItem;
import org.herac.tuxguitar.gui.items.menu.MeasureMenuItem;
import org.herac.tuxguitar.gui.items.menu.NoteEffectsMenuItem;
import org.herac.tuxguitar.gui.items.menu.PlayMenuItem;
import org.herac.tuxguitar.gui.items.menu.SettingsMenuItem;
import org.herac.tuxguitar.gui.items.menu.TrackMenuItem;
import org.herac.tuxguitar.gui.items.tool.CompositionToolItems;
import org.herac.tuxguitar.gui.items.tool.DurationToolItems;
import org.herac.tuxguitar.gui.items.tool.EditToolItems;
import org.herac.tuxguitar.gui.items.tool.FileToolItems;
import org.herac.tuxguitar.gui.items.tool.InsertToolItems;
import org.herac.tuxguitar.gui.items.tool.NoteToolItems;
import org.herac.tuxguitar.gui.items.tool.PlayerToolItems;
import org.herac.tuxguitar.gui.items.tool.RepeatToolItems;
import org.herac.tuxguitar.gui.items.tool.ViewToolItems;

public class ItemContainerManager {
    private static final int HEIGHT = 30;
    private TablatureEditor tablatureEditor;
    private Menu menuBar;
    public CoolBar coolBar;
    private List items;

    public ItemContainerManager(TablatureEditor tablatureEditor) {
        this.tablatureEditor = tablatureEditor;
        this.items = new ArrayList();
    }

    public void createToolbar(final Shell shell) {
        this.coolBar = new CoolBar((Composite)shell, 0x800000);
        ToolBar toolBar = new ToolBar((Composite)this.coolBar, 0x800040);
        FileToolItems fileToolItems = new FileToolItems(this.tablatureEditor, toolBar);
        fileToolItems.showItems();
        this.makeCoolItem(toolBar);
        toolBar = new ToolBar((Composite)this.coolBar, 0x800040);
        EditToolItems editToolItems = new EditToolItems(this.tablatureEditor, toolBar);
        editToolItems.showItems();
        this.makeCoolItem(toolBar);
        toolBar = new ToolBar((Composite)this.coolBar, 0x800040);
        DurationToolItems durationToolItems = new DurationToolItems(this.tablatureEditor, toolBar);
        durationToolItems.showItems();
        this.makeCoolItem(toolBar);
        toolBar = new ToolBar((Composite)this.coolBar, 0x800040);
        CompositionToolItems compositionToolItems = new CompositionToolItems(this.tablatureEditor, toolBar);
        compositionToolItems.showItems();
        this.makeCoolItem(toolBar);
        toolBar = new ToolBar((Composite)this.coolBar, 0x800040);
        RepeatToolItems repeatToolItems = new RepeatToolItems(this.tablatureEditor, toolBar);
        repeatToolItems.showItems();
        this.makeCoolItem(toolBar);
        toolBar = new ToolBar((Composite)this.coolBar, 0x800040);
        NoteToolItems noteToolItems = new NoteToolItems(this.tablatureEditor, toolBar);
        noteToolItems.showItems();
        this.makeCoolItem(toolBar);
        toolBar = new ToolBar((Composite)this.coolBar, 0x800040);
        PlayerToolItems playerToolItems = new PlayerToolItems(this.tablatureEditor, toolBar);
        playerToolItems.showItems();
        this.makeCoolItem(toolBar);
        toolBar = new ToolBar((Composite)this.coolBar, 0x800040);
        InsertToolItems insertToolItems = new InsertToolItems(this.tablatureEditor, toolBar);
        insertToolItems.showItems();
        this.makeCoolItem(toolBar);
        toolBar = new ToolBar((Composite)this.coolBar, 0x800040);
        ViewToolItems viewToolItems = new ViewToolItems(toolBar);
        viewToolItems.showItems();
        this.makeCoolItem(toolBar);
        this.items.add(fileToolItems);
        this.items.add(editToolItems);
        this.items.add(compositionToolItems);
        this.items.add(durationToolItems);
        this.items.add(repeatToolItems);
        this.items.add(noteToolItems);
        this.items.add(playerToolItems);
        this.items.add(insertToolItems);
        this.items.add(viewToolItems);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0, 5);
        this.coolBar.setLayoutData((Object)formData);
        this.coolBar.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                shell.layout();
            }
        });
    }

    private void makeCoolItem(ToolBar toolBar) {
        CoolItem coolItem = new CoolItem(this.coolBar, 0);
        coolItem.setControl((Control)toolBar);
        Point point = toolBar.computeSize(-1, -1);
        Point point2 = coolItem.computeSize(point.x, 30);
        coolItem.setMinimumSize(point2);
        coolItem.setSize(point2);
    }

    public void createMenu(Shell shell) {
        this.menuBar = new Menu((Decorations)shell, 2);
        FileMenuItem fileMenuItem = new FileMenuItem(shell, this.menuBar, 64, this.tablatureEditor);
        LayoutMenuItem layoutMenuItem = new LayoutMenuItem(shell, this.menuBar, 64, this.tablatureEditor);
        CompositionMenuItem compositionMenuItem = new CompositionMenuItem(shell, this.menuBar, 64, this.tablatureEditor);
        TrackMenuItem trackMenuItem = new TrackMenuItem(shell, this.menuBar, 64, this.tablatureEditor);
        MeasureMenuItem measureMenuItem = new MeasureMenuItem(shell, this.menuBar, 64, this.tablatureEditor);
        DurationMenuItem durationMenuItem = new DurationMenuItem(shell, this.menuBar, 64, this.tablatureEditor);
        NoteEffectsMenuItem noteEffectsMenuItem = new NoteEffectsMenuItem(shell, this.menuBar, 64, this.tablatureEditor);
        PlayMenuItem playMenuItem = new PlayMenuItem(shell, this.menuBar, 64, this.tablatureEditor);
        LanguageMenuItem languageMenuItem = new LanguageMenuItem(shell, this.menuBar, 64);
        SettingsMenuItem settingsMenuItem = new SettingsMenuItem(shell, this.menuBar, 64);
        HelpMenuItem helpMenuItem = new HelpMenuItem(shell, this.menuBar, 64);
        fileMenuItem.showItems();
        layoutMenuItem.showItems();
        compositionMenuItem.showItems();
        trackMenuItem.showItems();
        measureMenuItem.showItems();
        durationMenuItem.showItems();
        noteEffectsMenuItem.showItems();
        playMenuItem.showItems();
        languageMenuItem.showItems();
        settingsMenuItem.showItems();
        helpMenuItem.showItems();
        shell.setMenuBar(this.menuBar);
        this.items.add(fileMenuItem);
        this.items.add(layoutMenuItem);
        this.items.add(compositionMenuItem);
        this.items.add(trackMenuItem);
        this.items.add(measureMenuItem);
        this.items.add(durationMenuItem);
        this.items.add(noteEffectsMenuItem);
        this.items.add(playMenuItem);
        this.items.add(languageMenuItem);
        this.items.add(settingsMenuItem);
        this.items.add(helpMenuItem);
    }

    public void updateItems() {
        if (!this.menuBar.isDisposed() && !this.coolBar.isDisposed()) {
            for (ItemContainer itemContainer : this.items) {
                itemContainer.update();
            }
        }
    }

    public void loadProperties() {
        if (!this.menuBar.isDisposed() && !this.coolBar.isDisposed()) {
            for (ItemContainer itemContainer : this.items) {
                itemContainer.loadProperties();
            }
        }
    }

    public CoolBar getCoolbar() {
        return this.coolBar;
    }
}

