/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.clipboard;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.clipboard.CannotInsertTransferException;
import org.herac.tuxguitar.gui.clipboard.Transferable;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.undo.undoables.JoinedUndoable;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableAddMeasure;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableChangeMeasure;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableInsertMeasure;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;

public class MeasureTransferable
implements Transferable {
    public static final int TRANSFER_TYPE_REPLACE = 1;
    public static final int TRANSFER_TYPE_INSERT = 2;
    private TablatureEditor tablatureEditor;
    private List trackMeasures;
    private long copyPosition;
    private int transferType;

    public MeasureTransferable(TablatureEditor tablatureEditor, long l, long l2, boolean bl) {
        this.tablatureEditor = tablatureEditor;
        this.trackMeasures = new ArrayList();
        this.copyPosition = l;
        this.transferType = 1;
        this.getTransfer(l, l2, bl);
    }

    private void getTransfer(long l, long l2, boolean bl) {
        if (bl) {
            for (SongTrackCoords songTrackCoords : this.tablatureEditor.getTablature().getCaret().getSongCoords().getTrackCoords()) {
                List list = this.tablatureEditor.getSongManager().getTrackManager().copyMeasures(songTrackCoords.getTrack(), l, l2);
                this.trackMeasures.add(new TrackMeasures(songTrackCoords.getTrack().getNumber(), list));
            }
        } else {
            SongTrackCoords songTrackCoords = this.tablatureEditor.getTablature().getCaret().getSongTrackCoords();
            List list = this.tablatureEditor.getSongManager().getTrackManager().copyMeasures(songTrackCoords.getTrack(), l, l2);
            this.trackMeasures.add(new TrackMeasures(songTrackCoords.getTrack().getNumber(), list));
        }
    }

    public void insertTransfer() throws CannotInsertTransferException {
        if (this.transferType == 1) {
            this.replaceMeasures();
        } else if (this.transferType == 2) {
            this.insertMeasures();
        }
    }

    public void insertMeasures() throws CannotInsertTransferException {
        MeasureCoords measureCoords = this.tablatureEditor.getTablature().getCaret().getMeasureCoords();
        SongCoords songCoords = this.tablatureEditor.getTablature().getCaret().getSongCoords();
        if (measureCoords == null || songCoords == null || this.trackMeasures.isEmpty()) {
            throw new CannotInsertTransferException();
        }
        UndoableInsertMeasure undoableInsertMeasure = new UndoableInsertMeasure();
        int n = measureCoords.getMeasure().getNumber();
        long l = measureCoords.getMeasure().getStart() - this.copyPosition;
        for (SongTrackCoords songTrackCoords : this.tablatureEditor.getTablature().getSongCoords().getTrackCoords()) {
            List list = null;
            for (TrackMeasures trackMeasures : this.trackMeasures) {
                if (trackMeasures.getTrackNumber() != songTrackCoords.getTrack().getNumber()) continue;
                list = trackMeasures.getMeasures();
                break;
            }
            list = list == null ? this.getEmptyMeasures(((TrackMeasures)this.trackMeasures.get(0)).getMeasures()) : this.tablatureEditor.getSongManager().getTrackManager().getCloneMeasures(list);
            this.moveStart(songTrackCoords.getTrack(), list, l);
            undoableInsertMeasure.addUndo(songTrackCoords.getTrack().getNumber(), list);
            this.tablatureEditor.getSongManager().getTrackManager().insertMeasures(songTrackCoords.getTrack(), list, n);
        }
        this.tablatureEditor.getUndoManager().addEdit(undoableInsertMeasure.endUndo(((TrackMeasures)this.trackMeasures.get(0)).getMeasures().size()));
    }

    public void replaceMeasures() throws CannotInsertTransferException {
        int n;
        MeasureCoords measureCoords = this.tablatureEditor.getTablature().getCaret().getMeasureCoords();
        SongTrackCoords songTrackCoords = this.tablatureEditor.getTablature().getCaret().getSongTrackCoords();
        SongCoords songCoords = this.tablatureEditor.getTablature().getCaret().getSongCoords();
        if (measureCoords == null || songCoords == null || this.trackMeasures.isEmpty()) {
            throw new CannotInsertTransferException();
        }
        JoinedUndoable joinedUndoable = new JoinedUndoable();
        TrackMeasures trackMeasures = (TrackMeasures)this.trackMeasures.get(0);
        int n2 = trackMeasures.getMeasures().size();
        int n3 = measureCoords.getMeasure().getNumber();
        for (int i = n = songTrackCoords.getMeasuresCoords().size() - (n3 - 1); i < n2; ++i) {
            UndoableAddMeasure undoableAddMeasure = UndoableAddMeasure.startUndo();
            SongManager songManager = songCoords.getSongManager();
            songManager.addNewMeasureBeforeEnd();
            TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(songTrackCoords.getMeasuresCoords().size(), true);
            long l = songManager.getTrackManager().getLastMeasure(songTrackCoords.getTrack()).getStart();
            joinedUndoable.addUndoableEdit(undoableAddMeasure.endUndo(l));
        }
        UndoableChangeMeasure undoableChangeMeasure = new UndoableChangeMeasure();
        long l = measureCoords.getMeasure().getStart() - this.copyPosition;
        for (TrackMeasures trackMeasures2 : this.trackMeasures) {
            SongTrackCoords songTrackCoords2 = songCoords.getTrack(trackMeasures2.getTrackNumber());
            List list = this.tablatureEditor.getSongManager().getTrackManager().getCloneMeasures(trackMeasures2.getMeasures());
            this.moveStart(songTrackCoords2.getTrack(), list, l);
            for (Measure measure : list) {
                Measure measure2 = TuxGuitar.instance().getSongManager().getTrackManager().getMeasureAt(songTrackCoords2.getTrack(), measure.getStart());
                if (measure2 == null) continue;
                undoableChangeMeasure.addUndo(songTrackCoords2.getTrack().getNumber(), measure2, measure);
                this.tablatureEditor.getSongManager().getTrackManager().replaceMeasure(songTrackCoords2.getTrack(), measure);
            }
        }
        this.tablatureEditor.getSongManager().calculateMeasureStartWidthRepetitions();
        joinedUndoable.addUndoableEdit(undoableChangeMeasure.endUndo());
        this.tablatureEditor.getUndoManager().addEdit(joinedUndoable.endUndo());
    }

    private void moveStart(SongTrack songTrack, List list, long l) {
        for (Measure measure : list) {
            this.tablatureEditor.getSongManager().getTrackManager().moveMeasure(songTrack, measure, l, 0);
        }
    }

    private List getEmptyMeasures(List list) {
        ArrayList<Measure> arrayList = new ArrayList<Measure>();
        for (Measure measure : list) {
            int n = measure.getNumber();
            long l = measure.getStart();
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            TimeSignature timeSignature = (TimeSignature)measure.getTimeSignature().clone();
            Tempo tempo = (Tempo)measure.getTempo().clone();
            boolean bl = measure.isRepeatStart();
            int n2 = measure.getNumberOfRepetitions();
            arrayList.add(new Measure(n, l, arrayList2, arrayList3, timeSignature, tempo, bl, n2));
        }
        return arrayList;
    }

    public void setTransferType(int n) {
        this.transferType = n;
    }

    private class TrackMeasures {
        private long trackNumber;
        private List measures;

        public TrackMeasures(long l, List list) {
            this.trackNumber = l;
            this.measures = list;
        }

        public List getMeasures() {
            return this.measures;
        }

        public long getTrackNumber() {
            return this.trackNumber;
        }
    }
}

