/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.chord;

import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.herac.tuxguitar.gui.chord.ChordCreatorUtil;
import org.herac.tuxguitar.gui.chord.ChordEditor;
import org.herac.tuxguitar.gui.chord.ChordList;
import org.herac.tuxguitar.song.models.Chord;

public class ChordSelector
extends Composite {
    private ChordEditor editor;
    private ChordList list;
    private int[] tunning;
    private List tonicList;
    private List chordList;
    private List alterationList;

    public ChordSelector(Composite composite, int n) {
        super(composite, n);
        this.setLayout((Layout)new GridLayout(3, false));
        this.init();
    }

    public void init() {
        this.tonicList = new List((Composite)this, 2048);
        String[] stringArray = this.getTonicNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.tonicList.add(stringArray[i]);
        }
        this.tonicList.setSelection(0);
        this.chordList = new List((Composite)this, 2048);
        String[] stringArray2 = this.getChordNames();
        for (int i = 0; i < stringArray2.length; ++i) {
            this.chordList.add(stringArray2[i]);
        }
        this.chordList.setSelection(0);
        this.alterationList = new List((Composite)this, 2048);
        String[] stringArray3 = this.getAlterationNames();
        for (int i = 0; i < stringArray3.length; ++i) {
            this.alterationList.add(stringArray3[i]);
        }
        this.alterationList.setSelection(0);
        this.tonicList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ChordSelector.this.editor != null && ChordSelector.this.list != null) {
                    ChordSelector.this.showChord(ChordSelector.this.tonicList.getSelectionIndex() + 1, ChordSelector.this.chordList.getSelectionIndex() + 1, ChordSelector.this.alterationList.getSelectionIndex() + 1);
                    ChordSelector.this.list.redraw();
                }
            }
        });
        this.chordList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ChordSelector.this.editor != null && ChordSelector.this.list != null) {
                    ChordSelector.this.showChord(ChordSelector.this.tonicList.getSelectionIndex() + 1, ChordSelector.this.chordList.getSelectionIndex() + 1, ChordSelector.this.alterationList.getSelectionIndex() + 1);
                    ChordSelector.this.list.redraw();
                }
            }
        });
        this.alterationList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ChordSelector.this.editor != null && ChordSelector.this.list != null) {
                    ChordSelector.this.showChord(ChordSelector.this.tonicList.getSelectionIndex() + 1, ChordSelector.this.chordList.getSelectionIndex() + 1, ChordSelector.this.alterationList.getSelectionIndex() + 1);
                    ChordSelector.this.list.redraw();
                }
            }
        });
    }

    public void setEditor(ChordEditor chordEditor) {
        this.editor = chordEditor;
    }

    public void setList(ChordList chordList) {
        this.list = chordList;
    }

    public void setTunning(int[] nArray) {
        this.tunning = nArray;
    }

    private String[] getTonicNames() {
        String[] stringArray = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
        return stringArray;
    }

    private String[] getChordNames() {
        String[] stringArray = new String[]{"M", "m", "sus2", "sus4"};
        return stringArray;
    }

    private String[] getAlterationNames() {
        String[] stringArray = new String[]{"Normal", "7", "7M", "6", "5"};
        return stringArray;
    }

    private void showChord(int n, int n2, int n3) {
        int[] nArray = this.getRequiredNotes(n2, n3);
        int n4 = 0;
        int n5 = 3;
        ArrayList<Chord> arrayList = new ArrayList<Chord>();
        ChordCreatorUtil chordCreatorUtil = null;
        for (int i = 0; i < 10; ++i) {
            chordCreatorUtil = new ChordCreatorUtil(this.tunning, nArray, n, n4 + i, n5 + i);
            Chord chord = chordCreatorUtil.getChord();
            if (chord == null) continue;
            arrayList.add(chord);
        }
        this.list.setChords(arrayList);
    }

    private int[] getRequiredNotes(int n, int n2) {
        int[] nArray = null;
        int n3 = this.getAlterationRequired(n2);
        int n4 = n3 > 0 ? 1 : 0;
        switch (n) {
            case 1: {
                nArray = new int[3 + n4];
                nArray[0 + n4] = 1;
                nArray[1 + n4] = 5;
                nArray[2 + n4] = 8;
                break;
            }
            case 2: {
                nArray = new int[3 + n4];
                nArray[0 + n4] = 1;
                nArray[1 + n4] = 4;
                nArray[2 + n4] = 8;
                break;
            }
            case 3: {
                nArray = new int[4 + n4];
                nArray[0 + n4] = 3;
                nArray[1 + n4] = 1;
                nArray[2 + n4] = 5;
                nArray[3 + n4] = 8;
                break;
            }
            case 4: {
                nArray = new int[4 + n4];
                nArray[0 + n4] = 6;
                nArray[1 + n4] = 1;
                nArray[2 + n4] = 8;
                nArray[3 + n4] = 5;
            }
        }
        if (n3 > 0) {
            nArray[0] = n3;
        }
        return nArray;
    }

    private int getAlterationRequired(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 11;
                break;
            }
            case 3: {
                n2 = 12;
                break;
            }
            case 4: {
                n2 = 10;
                break;
            }
            case 5: {
                n2 = 8;
            }
        }
        return n2;
    }
}

