/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.chord;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ChordEditor
extends Composite {
    public static final int STRING_SPAN = 30;
    public static final int FRET_SPAN = 30;
    public static final short MIN_FRET = 1;
    public static final short MAX_FRET = 24;
    public static final short VIEWING_FRETS = 6;
    private boolean[] fisrtFrets;
    private int[] strings;
    private int[] frets;
    private short fret;
    private short maxStrings;
    private int width;
    private int height;
    private List points;

    public ChordEditor(Composite composite, int n) {
        super(composite, n);
        this.setMaxStrings((short)6);
        this.setBackground(this.getDisplay().getSystemColor(1));
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                ChordEditor.this.paintEditor(paintEvent.gc);
                paintEvent.gc.dispose();
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseUp(MouseEvent mouseEvent) {
                ChordEditor.this.checkPoint(mouseEvent.x, mouseEvent.y);
                ChordEditor.this.redraw();
            }
        });
        this.getVerticalBar().setMaximum(21);
        this.getVerticalBar().setMinimum(1);
        this.getVerticalBar().setThumb(1);
        this.getVerticalBar().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ChordEditor.this.setFret((short)ChordEditor.this.getVerticalBar().getSelection(), false);
                ChordEditor.this.redraw();
            }
        });
    }

    public ChordEditor(Composite composite, int n, short s) {
        this(composite, n | 0x200);
        this.init(s);
    }

    public void init(short s) {
        int n;
        this.fret = 1;
        this.maxStrings = s;
        this.fisrtFrets = new boolean[this.maxStrings];
        this.strings = new int[this.maxStrings];
        this.frets = new int[6];
        this.width = 30 * this.maxStrings - 30;
        this.height = 150;
        this.points = new ArrayList();
        for (n = 0; n < this.fisrtFrets.length; ++n) {
            this.fisrtFrets[n] = false;
        }
        for (n = 0; n < this.strings.length; ++n) {
            this.strings[n] = (n + 1) * 30;
        }
        for (n = 0; n < this.frets.length; ++n) {
            this.frets[n] = (n + 1) * 30;
        }
    }

    private void paintEditor(GC gC) {
        int n;
        gC.drawLine(20, 20, 30 + (this.width + 10), 20);
        gC.drawString(Integer.toString(this.getFret()), 10, 30);
        for (n = 0; n < this.strings.length; ++n) {
            gC.drawLine(this.strings[n], 30, this.strings[n], 30 + this.height);
        }
        for (n = 0; n < this.frets.length; ++n) {
            gC.drawLine(30, this.frets[n], 30 + this.width, this.frets[n]);
        }
        gC.setLineWidth(10);
        gC.setForeground(this.getDisplay().getSystemColor(2));
        for (Point point : this.points) {
            gC.drawOval(point.x - 2, point.y + 15, 5, 5);
        }
        gC.setLineWidth(1);
        for (int i = 0; i < this.fisrtFrets.length; ++i) {
            int n2;
            int n3;
            if (this.hasPoints(i)) continue;
            if (this.fisrtFrets[i]) {
                n3 = this.strings[i] - 7;
                n2 = 3;
                gC.drawOval(n3, n2, 14, 14);
                continue;
            }
            n3 = this.strings[i];
            n2 = 10;
            gC.drawLine(n3 - 6, n2 + 6, n3 + 7, n2 - 7);
            gC.drawLine(n3 - 6, n2 - 6, n3 + 7, n2 + 7);
        }
    }

    private void checkPoint(int n, int n2) {
        Point point;
        int n3 = this.getStringIndex(n);
        int n4 = this.getFretIndex(n2);
        if (n2 < 30) {
            this.fisrtFrets[n3] = !this.fisrtFrets[n3];
            this.removePointsAtStringLine(this.strings[n3]);
        } else if (n2 < 180 && !this.removePoint(point = new Point(this.strings[n3], this.frets[n4]))) {
            this.fisrtFrets[n3] = false;
            this.removePointsAtStringLine(this.strings[n3]);
            this.addPoint(point);
            this.orderPoints();
        }
    }

    private boolean removePoint(Point point) {
        for (Point point2 : this.points) {
            if (point2.x != point.x || point2.y != point.y) continue;
            this.points.remove(point);
            return true;
        }
        return false;
    }

    private void orderPoints() {
        for (int i = 0; i < this.points.size(); ++i) {
            Point point = null;
            for (int j = i; j < this.points.size(); ++j) {
                Point point2 = (Point)this.points.get(j);
                if (point != null && point2.x >= point.x) continue;
                point = point2;
            }
            this.points.remove(point);
            this.points.add(i, point);
        }
    }

    private void removePointsAtStringLine(int n) {
        for (Point point : this.points) {
            if (point.x != n) continue;
            this.points.remove(point);
            break;
        }
    }

    private void addPoint(Point point) {
        this.points.add(point);
    }

    private int getStringIndex(int n) {
        int n2 = -1;
        for (int i = 0; i < this.strings.length; ++i) {
            if (n2 < 0) {
                n2 = i;
                continue;
            }
            int n3 = Math.abs(n - this.strings[n2]);
            int n4 = Math.abs(n - this.strings[i]);
            if (n4 >= n3) continue;
            n2 = i;
        }
        return n2;
    }

    private int getFretIndex(int n) {
        int n2 = -1;
        for (int i = 0; i < this.frets.length; ++i) {
            if (n2 < 0) {
                n2 = i;
                continue;
            }
            int n3 = Math.abs(n - (this.frets[n2] + 15));
            int n4 = Math.abs(n - (this.frets[i] + 15));
            if (n4 >= n3) continue;
            n2 = i;
        }
        return n2;
    }

    private boolean hasPoints(int n) {
        for (Point point : this.points) {
            if (point.x != this.strings[n]) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    public int getValue(int n) {
        int n2 = -1;
        if (this.fisrtFrets[this.maxStrings - n]) {
            n2 = 0;
        }
        if (n2 < 0) {
            for (Point point : this.points) {
                if (n != this.maxStrings - this.getStringIndex(point.x)) continue;
                n2 = this.getFretIndex(point.y + 15) + 1;
                n2 += this.getFret() - 1;
            }
        }
        return n2;
    }

    public void addValue(int n, int n2) {
        if (n2 >= 1 && n2 <= this.maxStrings) {
            this.fisrtFrets[this.maxStrings - n2] = false;
            this.removePointsAtStringLine(this.strings[this.maxStrings - n2]);
            if (n == 0) {
                this.fisrtFrets[this.maxStrings - n2] = true;
            } else if (n >= 0 && (n -= this.getFret() - 1) > 0 && n <= 6) {
                this.addPoint(new Point(this.strings[this.maxStrings - n2], this.frets[n - 1]));
            }
        }
    }

    public short getFret() {
        return this.fret;
    }

    public void setFret(short s) {
        this.setFret(s, true);
    }

    private void setFret(short s, boolean bl) {
        if (s >= 1 && s <= 24) {
            this.fret = s;
        }
        if (bl) {
            this.getVerticalBar().setSelection((int)this.fret);
        }
    }

    public short getMaxStrings() {
        return this.maxStrings;
    }

    public void setMaxStrings(short s) {
        this.maxStrings = s;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

