/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.FileChooser;

public class ExportMidiAction
extends Action {
    public static final String NAME = "EXPORT_MIDI";

    public ExportMidiAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        String[] stringArray;
        String[] stringArray2;
        Shell shell;
        FileChooser fileChooser;
        String string;
        String string2 = this.getEditor().getMemoryHelper().getLastChooserPath();
        String string3 = this.getDefaultFileName(this.getEditor().getMemoryHelper().getFileName());
        if (string3 != null && !this.isSuportedFormat(string3)) {
            this.chengeFormat(string3, this.getDefaultExtension());
        }
        if ((string = (fileChooser = new FileChooser(shell = this.getEditor().getTablature().getShell(), stringArray2 = null, stringArray = new String[]{"*.mid"}, string2, string3)).show(8192)) != null) {
            ConfirmDialog confirmDialog;
            String string4;
            File file;
            boolean bl = true;
            if (!this.isSuportedFormat(string)) {
                string = string + this.getDefaultExtension();
            }
            if ((file = new File(string4 = string)).exists() && !(confirmDialog = new ConfirmDialog(this.getEditor().getTablature().getShell(), TuxGuitar.getProperty("replace-file-question"))).confirm()) {
                bl = false;
            }
            if (bl) {
                this.getEditor().getTablature().changeCursor(1);
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            ExportMidiAction.this.getEditor().getSongManager().getPlayer().write(new FileOutputStream(string4));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            fileNotFoundException.printStackTrace();
                        }
                        new SyncThread(new Runnable(){

                            public void run() {
                                if (!TuxGuitar.isDisposed()) {
                                    ExportMidiAction.this.getEditor().getTablature().changeCursor(0);
                                }
                            }
                        }).start();
                    }
                }).start();
            }
        }
        return true;
    }

    private String getDefaultFileName(String string) {
        String string2 = "untitled";
        String string3 = this.getDefaultExtension();
        if (string == null) {
            string = string2 + string3;
        } else if (!this.isSuportedFormat(string)) {
            string = this.chengeFormat(string, string3);
        }
        return string;
    }

    private boolean isSuportedFormat(String string) {
        return string.endsWith(".mid");
    }

    private String chengeFormat(String string, String string2) {
        return this.removeExtension(string) + string2;
    }

    private String removeExtension(String string) {
        int n = string.lastIndexOf(46);
        return string.substring(0, n);
    }

    private String getDefaultExtension() {
        return ".mid";
    }
}

