/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.song.managers.SongManager;

public abstract class Action
implements SelectionListener,
MouseListener {
    private String name;
    private boolean editableKeyBinding;
    private TablatureEditor tablatureEditor;

    public Action(String string, boolean bl, TablatureEditor tablatureEditor) {
        this.name = string;
        this.editableKeyBinding = bl;
        this.tablatureEditor = tablatureEditor;
    }

    public Action(String string, TablatureEditor tablatureEditor) {
        this(string, false, tablatureEditor);
    }

    public abstract boolean doAction(TypedEvent var1);

    protected void update() {
        TuxGuitar.instance().getItemContainerManager().updateItems();
    }

    public synchronized void process(TypedEvent typedEvent) {
        boolean bl = this.doAction(typedEvent);
        if (bl) {
            this.setLastEvent(typedEvent);
            this.update();
        }
    }

    public boolean isEditableKeyBinding() {
        return this.editableKeyBinding;
    }

    public String getName() {
        return this.name;
    }

    protected synchronized void redraw() {
        TuxGuitar.instance().redraw();
    }

    protected synchronized void updateTablature() {
        TuxGuitar.instance().fireUpdate();
    }

    protected void fireUpdate(int n, boolean bl) {
        this.tablatureEditor.getTablature().getViewLayout().fireUpdate(n, bl);
    }

    protected void fireUpdate(int n) {
        this.fireUpdate(n, false);
    }

    protected TablatureEditor getEditor() {
        return this.tablatureEditor;
    }

    protected SongManager getSongManager() {
        return this.tablatureEditor.getSongManager();
    }

    protected TypedEvent getLastEvent() {
        return TuxGuitar.instance().getActionContainer().getLastEvent();
    }

    private void setLastEvent(TypedEvent typedEvent) {
        TuxGuitar.instance().getActionContainer().setLastEvent(typedEvent);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.process((TypedEvent)selectionEvent);
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseDown(MouseEvent mouseEvent) {
    }

    public void mouseUp(MouseEvent mouseEvent) {
        this.process((TypedEvent)mouseEvent);
    }
}

