/*
 * Created on 16-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.io.tg;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.herac.tuxguitar.song.models.BendEffect;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.Tupleto;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class TGInputStream{
    private static final String TG_VERSION = "TG_DEVEL-0.01";
    private DataInputStream dataInputStream;


    public TGInputStream(FileInputStream file) throws FileNotFoundException {
        this.dataInputStream = new DataInputStream(file);
    }

    public TGInputStream(String fileName) throws FileNotFoundException {        
        this(new FileInputStream(new File(fileName)));             
    }          
    
    
    
    public Song read(){        
        try {     
            String version = this.readVersion();
            Song song = this.readSong();            
            this.dataInputStream.close();
            return song;
        } catch (IOException e) {
            e.printStackTrace();
        }        
        return null;
    }
    
    private String readVersion(){
        String version = readString();
        
        return version;
    }

    private Song readSong(){
        //leo el nombre
        String name = readString();
        
        //leo el interprete
        String interpret = readString();
        
        //leo el album
        String album = readString();

        //leo el autor
        String author = readString();
        
        //leo la cantidad de pistas
        int trackCount = readInt();
        
        //leo las pistas
        List tracks = new ArrayList(trackCount);
        for(int i = 0;i < trackCount;i++){
            tracks.add(readTrack());
        }
        
        
        return new Song(name,interpret,album,author,tracks);
    }
    
    private SongTrack readTrack(){
        //leo el canal
        int channel = readInt();
        
        //leo el instrumento
        int instrument = readInt();        
        
    
        //leo la cantidad de compases
        int measureCount = readInt();
        
        //leo los compases
        List measures = new ArrayList(measureCount);
        for(int i = 0;i < measureCount;i++){
            measures.add(readMeasure());
        }                        
        
        //leo la cantidad de cuerdas
        int stringCount = readInt();
        
        //leo las cuerdas
        List strings = new ArrayList(stringCount);
        for(int i = 0;i < stringCount;i++){
            strings.add(readInstrumentString());
        }        
        
        return new SongTrack(channel,instrument,measures,strings);
    }
    
    
    private Measure readMeasure(){
        //leo el start
        long start = readLong();
        
      
        //leo la cantidad de notas
        int noteCount = readInt();
        
        //leo las notas
        List notes = new ArrayList(noteCount);
        for(int i = 0;i < noteCount;i++){
            notes.add(readNote());
        }                      
        
        //leo la cantidad de silencios
        int silenceCount = readInt();
        
        //leo los silencios
        List silences = new ArrayList(silenceCount);
        for(int i = 0;i < silenceCount;i++){
            silences.add(readSilence());
        }                                             
        
        //leo el timeSignature
        TimeSignature timeSignature = readTimeSignature();        
        
        //leo el tempo
        Tempo tempo = readTempo();        
        
        //leo el comienzo de la repeticion
        boolean repeatStart = readBoolean();           
        
        //leo el numero de repeticiones
        int numberOfRepetitions = readInt();   
        
        return new Measure(start,notes,silences,timeSignature,tempo,repeatStart,numberOfRepetitions);
        
    }
    
    private Note readNote(){        
        //leo el valor
        int value = readInt();
        
        //leo el start
        long start = readLong();   
        
        //leo la duracion
        Duration duration = readDuration();
        
        //leo el velocity
        int velocity = readInt();
        
        //leo la cuerda
        int string = readInt();        
        
        //leo la ligadura
        boolean tiedNote = readBoolean();
        
        //leo los efectos
        NoteEffect effect = readNoteEffect();
                
        return new Note(value,start,duration,velocity,string,tiedNote,effect);
    }    
    
    
    private Silence readSilence(){                
        //leo el start
        long start = readLong();   
        
        //leo la duracion
        Duration duration = readDuration();
        
        return new Silence(start,duration);
    }       
    
    private InstrumentString readInstrumentString(){
        //leo el numero
        int number = readInt();
        
        //leo el valor
        int value = readInt();        
                
        return new InstrumentString(number,value);
    }           
    
    private Tempo readTempo(){
        //leo el valor
        int value = readInt();
        
        return new Tempo(value);
    }    
    
    
    private TimeSignature readTimeSignature(){
        //leo el numerador
        int numerator = readInt();
        
        //leo el denominador
        Duration denominator = readDuration();
        
        return new TimeSignature(numerator,denominator); 
    }
    
    private Duration readDuration(){
        //leo el valor
        int value = readInt();
        
        //leo el puntillo
        boolean dotted = readBoolean();
        
        //leo el doble puntillo
        boolean doubleDotted = readBoolean();
        
        //leo el tupleto
        Tupleto tupleto = readTupleto();
        
        return new Duration(value,dotted,doubleDotted,tupleto);
    }    
    
    private Tupleto readTupleto(){                
        //leo los enters
        int enters = readInt();
        
        //leo los tiempos
        int times = readInt();
        
        return new Tupleto(enters,times);
    }           
    
    private NoteEffect readNoteEffect(){
        NoteEffect effect = new NoteEffect();
        
        //leo el vibrato
        effect.setVibrato(readBoolean());
        
        //leo el bend
        if(readBoolean()){
            effect.setBend(readBendEffect());
        }
        
        //leo el slide
        effect.setSlide(readBoolean());
        
        //leo el hammer
        effect.setHammer(readBoolean());      
        
        return effect;
    }
    
    private BendEffect readBendEffect(){
        BendEffect bend = new BendEffect();
        
        //leo la cantidad de puntos
        int count = readInt();
        
        for(int i = 0;i < count;i++){            
            //leo la posicion
            int position = readInt();
            
            //leo el valor
            int value = readInt();
            
            //agrego el punto
            bend.addPoint(position,value);            
        }        
        return bend;
    }
    

    private int readInt(){
        try {
            return this.dataInputStream.readInt();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }
    
    private long readLong(){
        try {
            return this.dataInputStream.readLong();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }    
    
    
    private String readString(){
        try {
            int length = this.dataInputStream.read();
            char[] chars = new char[length];
            for(int i = 0;i < chars.length; i++){
                chars[i] = this.dataInputStream.readChar();
            }
            
            return String.copyValueOf(chars);
        } catch (IOException e) {            
            e.printStackTrace();
        }
        return null;
        
    }        
    
    private boolean readBoolean(){
        try {
            return this.dataInputStream.readBoolean();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }      
    
}
