/*
 * Created on 04-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.tab;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.SongTrack;


/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public abstract class ViewLayout {
    public static final int DEFAULT_FIRST_TRACK_SPAN = 50;
    public static final int DEFAULT_TRACK_SPAN = 150;
    
    private Tablature tablature;
    private SongManager songManager;
    private boolean multitrack;
    private List quarterSpanHelpers;
    private int width;
    private int height;
    
    public ViewLayout(Tablature tablature,SongManager songManager,boolean multitrack){
        this.tablature = tablature;
        this.songManager = songManager;
        this.multitrack = multitrack;
        this.quarterSpanHelpers = new ArrayList();
    }
    
    public abstract void paintSong(GC gc,Rectangle clientArea,int fromX,int fromY);
    public abstract void paintTracks(List tracksCoords,GC gc,Rectangle clientArea,int fromX,int fromY);
    public abstract void paintMeasures(SongTrackCoords trackCoords,List measuresCoords,GC gc,int fromX, int fromY,Rectangle clientArea);
    public abstract void paintStrings(SongTrackCoords trackCoords,GC gc,int fromY,Rectangle clientArea);
    public abstract SongTrackCoords getTrackAt(List tracksCoords,int y,int vScroll);
    public abstract void followMeasure(MeasureCoords measure,boolean redraw);
    
    
    
    
    public void updateSong(){
        createTracks();
        updateTracks();          
    }
    
    public void createTracks() {
        getTablature().getSongCoords().getTrackCoords().clear();        
        getQuarterSpans().clear();   
        
        for (int trackIdx = 0; trackIdx < getSongManager().getSong().getTracks().size(); trackIdx++) {
            SongTrack track = (SongTrack) getSongManager().getSong().getTracks().get(trackIdx);
            SongTrackCoords trackCoords = new SongTrackCoords(getTablature(),getSongManager(), track);
            createMeasures(trackCoords);
            getTablature().getSongCoords().getTrackCoords().add(trackCoords);            
        }
    }    
    
    public void updateTracks() {
        int width = 0;
        int height = 0;
        int maxWidth = 0;

        for (int trackIdx = 0; trackIdx < getTablature().getSongCoords().getTrackCoords().size(); trackIdx++) {
            SongTrackCoords trackCoords = (SongTrackCoords)getTablature().getSongCoords().getTrackCoords().get(trackIdx);
            updateMeasures(trackCoords);
            if(trackCoords.getWidth() > maxWidth){
                maxWidth = trackCoords.getWidth();
            }
            height += trackCoords.getHeight() + DEFAULT_TRACK_SPAN;
           
        }        
        getTablature().getSongCoords().updateRepetitions();
    }    
    
    public void createMeasures(SongTrackCoords trackCoords) {
        long caretPosition = getTablature().getCaret().getPosition();
        
        trackCoords.getMeasuresCoords().clear();
        for (int measureIdx = 0; measureIdx < trackCoords.getTrack().getMeasures().size(); measureIdx++) {
            Measure measure = (Measure) trackCoords.getTrack().getMeasures().get(measureIdx);
            MeasureCoords measureCoords = new MeasureCoords(measureIdx,getSongManager(),getTablature(), measure,trackCoords);            
            measureCoords.create();                                    
            trackCoords.getMeasuresCoords().add(measureCoords);
            
            if(getQuarterSpans().size() > measureIdx){                                
                getQuarterSpan(measureIdx).setQuarterSpan(measureCoords.getQuarterSpan());
            }else{
                addQuarterSpan(new QuarterSpanHelper(measureCoords.getQuarterSpan()));
            }
            
            //verifico si el caret esta en este compas
            if(caretPosition >= measureCoords.getMeasure().getStart() && caretPosition < measureCoords.getMeasure().getLength()){                
                measureCoords.setCaret(getTablature().getCaret());
            }
        }
    }
    
    public void updateMeasures(SongTrackCoords trackCoords) {
        int width = 0;
        int maxHeight = 0;
        for (int measureIdx = 0; measureIdx < trackCoords.getMeasuresCoords().size(); measureIdx++) {
            MeasureCoords measureCoords =  (MeasureCoords) trackCoords.getMeasuresCoords().get(measureIdx);                             
            
            //si es en modo multitrack. asigno mayor quarterSpan para este compas.
            measureCoords.setQuarterSpan(getQuarterSpan(getQuarterSpan(measureIdx),measureCoords));     
            
            //asigno la posicion dentro del compas
            measureCoords.setPosX(width);
            measureCoords.setPosY(0);    
            
            measureCoords.update();
            
            width += measureCoords.getWidth();
            if(measureCoords.getHeight() > maxHeight){
                maxHeight = measureCoords.getHeight();
            }                    
        }
        
        trackCoords.setWidth(width);
        trackCoords.setHeight(maxHeight);
    }    
    
    
    
    
    public void fireUpdate(int measureId,boolean isNew){
        QuarterSpanHelper quarterSpan = null;
        if(getQuarterSpans().size() > measureId){                                
            quarterSpan = getQuarterSpan(measureId);
            quarterSpan.reset();
        }else{
            quarterSpan = new QuarterSpanHelper();
            getQuarterSpans().add(quarterSpan);
        }         
        
        for (int trackIdx = 0; trackIdx < getTablature().getSongCoords().getTrackCoords().size(); trackIdx++) {
            SongTrackCoords trackCoords = (SongTrackCoords)getTablature().getSongCoords().getTrackCoords().get(trackIdx);
            trackCoords.fireChanges(measureId,quarterSpan,isNew);   
        } 
        for (int trackIdx = 0; trackIdx < getTablature().getSongCoords().getTrackCoords().size(); trackIdx++) {
            SongTrackCoords trackCoords = (SongTrackCoords)getTablature().getSongCoords().getTrackCoords().get(trackIdx);
            trackCoords.fireUpdate(measureId,quarterSpan);
        }            
    }    
    
    
    
    
    
    
    
    protected boolean isMultiTrack(){
        return true;
    }

    protected int getTrackCount(){
        if(multitrack){
            return songManager.getSong().getTracks().size();
        }
        return 1;
    }           
    
    
    public int getQuarterSpan(QuarterSpanHelper quarterSpan,MeasureCoords measure){
        if(isMultitrack()){
            return quarterSpan.getQuarterSpan();
        }else{
            return measure.getQuarterSpan();
        }
    }    
    
    
    public SongManager getSongManager() {
        return songManager;
    }
    public void setSongManager(SongManager songManager) {
        this.songManager = songManager;
    }
    public Tablature getTablature() {
        return tablature;
    }
    public void setTablature(Tablature tablature) {
        this.tablature = tablature;
    }
    public int getHeight() {
        return height;
    }
    public void setHeight(int height) {
        this.height = height;
    }
    public int getWidth() {
        return width;
    }
    public void setWidth(int width) {
        this.width = width;
    }
    
    
    public boolean isMultitrack() {
        return multitrack;
    }
    public void setMultitrack(boolean multitrack) {
        this.multitrack = multitrack;
    }
    
    public List getQuarterSpans(){
        return this.quarterSpanHelpers;
    }
    
    public QuarterSpanHelper getQuarterSpan(int i){
        return (QuarterSpanHelper)this.quarterSpanHelpers.get(i);
    }    

    public void addQuarterSpan(QuarterSpanHelper quarterSpan){
        this.quarterSpanHelpers.add(quarterSpan);
    }    
}
