/*
 * Created on 02-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.measure.AddMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.CopyMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.GoFirstMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.GoLastMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.GoNextMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.GoPreviousMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.PasteMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.RemoveMeasureAction;
import org.herac.tuxguitar.gui.items.ItemContainer;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class MeasureMenuItem implements ItemContainer{
    private TablatureEditor tablatureEditor;
    private MenuItem measureMenuItem;
    private Menu menu; 
    private MenuItem first;
    private MenuItem last;
    private MenuItem next;
    private MenuItem previous;
    private MenuItem addMeasure;
    private MenuItem removeMeasure;
    private MenuItem copyMeasure;
    private MenuItem pasteMeasure;
    
    public MeasureMenuItem(Shell shell,Menu parent, int style,TablatureEditor tablatureEditor) {
        this.measureMenuItem = new MenuItem(parent, style);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu(shell, SWT.DROP_DOWN);
    }

    
    public void showItems(){  
        //--First--
        this.first = new MenuItem(this.menu, SWT.PUSH);
        this.first.addSelectionListener(TuxGuitar.instance().getAction(GoFirstMeasureAction.NAME));        
        //--previous--
        this.previous = new MenuItem(this.menu, SWT.PUSH); 
        this.previous.addSelectionListener(TuxGuitar.instance().getAction(GoPreviousMeasureAction.NAME));        
        //--next--
        this.next = new MenuItem(this.menu, SWT.PUSH);
        this.next.addSelectionListener(TuxGuitar.instance().getAction(GoNextMeasureAction.NAME));        
        //--last--
        this.last = new MenuItem(this.menu, SWT.PUSH);          
        this.last.addSelectionListener(TuxGuitar.instance().getAction(GoLastMeasureAction.NAME));        

        //--SEPARATOR
        new MenuItem(this.menu, SWT.SEPARATOR);          
        //--ADD TRACK--
        this.addMeasure = new MenuItem(this.menu, SWT.PUSH);       
        this.addMeasure.addSelectionListener(TuxGuitar.instance().getAction(AddMeasureAction.NAME));         
        //--REMOVE TRACK--
        this.removeMeasure = new MenuItem(this.menu, SWT.PUSH);   
        this.removeMeasure.addSelectionListener(TuxGuitar.instance().getAction(RemoveMeasureAction.NAME)); 
                
        //--SEPARATOR
        new MenuItem(this.menu, SWT.SEPARATOR);          
        //--COPY--
        this.copyMeasure = new MenuItem(this.menu, SWT.PUSH);      
        this.copyMeasure.addSelectionListener(TuxGuitar.instance().getAction(CopyMeasureAction.NAME)); 
        //--PASTE--
        this.pasteMeasure = new MenuItem(this.menu, SWT.PUSH);
   
        this.pasteMeasure.addSelectionListener(TuxGuitar.instance().getAction(PasteMeasureAction.NAME)); 
           
        
        this.measureMenuItem.setMenu(menu);     
        
        this.loadProperties();
    }

    
    public void update(){
        Caret caret = tablatureEditor.getTablature().getCaret();        
        SongTrackCoords track = caret.getSongTrackCoords();  
        MeasureCoords measure = caret.getMeasureCoords();
        
        this.previous.setEnabled(measure.getMeasureId() > 0);
        this.next.setEnabled(measure.getMeasureId() + 1 < track.getTrack().getMeasures().size());
    }
    
    public void loadProperties(){
        this.measureMenuItem.setText(TuxGuitar.getProperty("measure"));        
        this.first.setText(TuxGuitar.getProperty("measure.first"));
        this.last.setText(TuxGuitar.getProperty("measure.last"));
        this.previous.setText(TuxGuitar.getProperty("measure.previous"));
        this.next.setText(TuxGuitar.getProperty("measure.next"));        
        this.addMeasure.setText(TuxGuitar.getProperty("measure.add"));
        this.removeMeasure.setText(TuxGuitar.getProperty("measure.remove"));
        this.copyMeasure.setText(TuxGuitar.getProperty("measure.copy"));
        this.pasteMeasure.setText(TuxGuitar.getProperty("measure.paste"));        
    }         
}
