/*
 * Created on 02-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.layout.SetLinearLayoutAction;
import org.herac.tuxguitar.gui.actions.layout.SetMultitrackViewAction;
import org.herac.tuxguitar.gui.actions.layout.SetPageLayoutAction;
import org.herac.tuxguitar.gui.items.ItemContainer;
import org.herac.tuxguitar.gui.tab.LinearViewLayout;
import org.herac.tuxguitar.gui.tab.PageViewLayout;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class LayoutMenuItem implements ItemContainer{
    private TablatureEditor tablatureEditor;
    private MenuItem layoutMenuItem;
    private Menu menu; 
    private MenuItem pageLayout;
    private MenuItem linearLayout;
    private MenuItem multitrack;

    
    public LayoutMenuItem(Shell shell,Menu parent, int style,TablatureEditor tablatureEditor) {
        this.layoutMenuItem = new MenuItem(parent, style);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu(shell, SWT.DROP_DOWN);
    }

    
    public void showItems(){  
        //--PAGE LAYOUT--
        this.pageLayout = new MenuItem(this.menu, SWT.RADIO);        
        this.pageLayout.addSelectionListener(TuxGuitar.instance().getAction(SetPageLayoutAction.NAME));
        //--LINEAR LAYOUT--
        this.linearLayout = new MenuItem(this.menu, SWT.RADIO);  
        this.linearLayout.addSelectionListener(TuxGuitar.instance().getAction(SetLinearLayoutAction.NAME));        
        //--MULTITRACK--
        this.multitrack = new MenuItem(this.menu, SWT.CHECK);
        
        this.multitrack.addSelectionListener(TuxGuitar.instance().getAction(SetMultitrackViewAction.NAME));        
        
        
        this.layoutMenuItem.setMenu(menu);    
        
        this.loadProperties();
    }

    
    public void update(){
        this.pageLayout.setSelection(this.tablatureEditor.getTablature().getViewLayout() instanceof PageViewLayout);
        this.linearLayout.setSelection(this.tablatureEditor.getTablature().getViewLayout() instanceof LinearViewLayout);
        this.multitrack.setSelection(this.tablatureEditor.getTablature().getViewLayout().isMultitrack());
    }
    
    public void loadProperties(){
        this.layoutMenuItem.setText(TuxGuitar.getProperty("layout"));        
        this.pageLayout.setText(TuxGuitar.getProperty("layout.page"));
        this.linearLayout.setText(TuxGuitar.getProperty("layout.linear"));
        this.multitrack.setText(TuxGuitar.getProperty("layout.multitrack"));
    }          
}
