/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.duration;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Tupleto;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ChangeTupletoDurationAction extends Action{
    public static final String NAME = "CHANGE_TUPLETO_DURATION";
    
    public ChangeTupletoDurationAction(TablatureEditor tablatureEditor) {
        super(NAME,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
        boolean isKeyEvent = false;
        if(e instanceof KeyEvent){
            KeyEvent keyEvent = (KeyEvent)e;
            if (keyEvent.character != '/'){
                return false;
            }        
            isKeyEvent = true;
        }         
        if(!isKeyEvent){
            Tupleto tupleto = defaultTupleto();
            if(e.widget.getData() != null && e.widget.getData() instanceof Tupleto){
                tupleto = (Tupleto)e.widget.getData();
            }        
        
            if(getSelectedDuration().getTupleto().isEqual(tupleto)){
                setTupleto(noTupleto());              
            }else{
                setTupleto(tupleto);
            }
        }
        else{        
            if(getSelectedDuration().getTupleto().isEqual(Duration.NO_TUPLETO)){            
                setTupleto(defaultTupleto());
            }else{
                setTupleto(noTupleto());                    
            }
        }
        setDurations();     
        return true;
    }

    private Tupleto noTupleto(){
        return new Tupleto(1,1);
    }
    
    private Tupleto defaultTupleto(){
        return new Tupleto(3,2);
    }
    
    private void setTupleto(Tupleto tupleto){
        getSelectedDuration().getTupleto().setEnters(tupleto.getEnters());
        getSelectedDuration().getTupleto().setTimes(tupleto.getTimes());        
    }
    
    private void setDurations() {                
        Caret caret = getEditor().getTablature().getCaret();            
        caret.changeDuration((Duration)getSelectedDuration().clone());
        fireUpdate(getEditor().getTablature().getCaret().getMeasureCoords().getMeasureId());
        redraw();        
    }    
    
    public Duration getSelectedDuration(){
        return getEditor().getTablature().getCaret().getDuration();
    }    

}
