/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongCoords;
import org.herac.tuxguitar.song.models.Tempo;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ChangeTempoAction extends Action{
    public static final String NAME = "CHANGE_TEMPO";
    
    public ChangeTempoAction(TablatureEditor tablatureEditor) {
        super(NAME,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
        showDialog(getEditor().getTablature().getShell());
        return true;
    }

    
    public void showDialog(Shell shell) {
        MeasureCoords measure = getEditor().getTablature().getCaret().getMeasureCoords();
        if (measure != null) {
            final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);

            GridLayout layout = new GridLayout(2, true);
            layout.marginTop = 20;
            layout.marginLeft = 20;
            layout.marginRight = 20;            
            layout.verticalSpacing = 20;      
            layout.horizontalSpacing = 10;     
            dialog.setLayout(layout);
            dialog.setText(TuxGuitar.getProperty("composition.tempo"));

            Tempo currentTempo = measure.getMeasure().getTempo();
            //-------numerator-------------------------------------
            Label tempoLabel = new Label(dialog, SWT.NULL);
            tempoLabel.setText(TuxGuitar.getProperty("composition.tempo"));
            
            final Text tempo = new Text(dialog, SWT.BORDER);
            tempo.setLayoutData(new GridData(50,13));
            tempo.setText(Integer.toString(currentTempo.getValue()));
            
            
            final Button buttonOK = new Button(dialog, SWT.PUSH);
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            buttonOK.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
            buttonOK.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {                       
                    int tempoValue = Integer.parseInt(tempo.getText());                    
                    Tempo tempo = new Tempo(tempoValue);                                       
                    setTempo(tempo);
                    
                    dialog.dispose();
                }
            });

            Button buttonCancel = new Button(dialog, SWT.PUSH);
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });

            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
        }
    }
    
    
    private void setTempo(Tempo tempo){
        Caret caret = getEditor().getTablature().getCaret();
        SongCoords songCoords = caret.getSongCoords();
        MeasureCoords measure = caret.getMeasureCoords();
        
        songCoords.changeTempo(measure.getMeasure().getStart(),tempo,true);
       
        //actualizo la tablatura
        updateTablature();
        caret.update(caret.getMeasureCoords().getMeasure());
        redraw();                
    }    

}
