/*
 * Created on 25-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui;

import java.io.File;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.actions.ActionContainer;
import org.herac.tuxguitar.gui.items.ItemContainerManager;
import org.herac.tuxguitar.gui.language.LanguageManager;
import org.herac.tuxguitar.song.managers.SongManager;
/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class TuxGuitar {    
    private static TuxGuitar instance;
    private String basePath;
    private Display display;
    private Shell shell;
    private SongManager songManager;
    private LanguageManager languageManager;
    private TablatureEditor tablatureEditor;    
    private ActionContainer actionContainer;
    private ItemContainerManager itemContainerManager;
    
    
    
    public static void main(String[] args) {        
        TuxGuitar.instance().displayGUI();
    }

    public TuxGuitar(){
        this.basePath = new File("").getAbsolutePath() + File.separator ;               
    }
    
	public static TuxGuitar instance(){
		if (instance == null){
			synchronized(TuxGuitar.class){
				instance = new TuxGuitar();
			}
		}
		
		return instance;
	}    
    
	private void initLanguage(){
	    this.languageManager = new LanguageManager();	    
	    this.languageManager.setLanguage("en");
	}
	
    public void displayGUI() {        
        this.initLanguage();
        this.display = new Display();
        
        Shell splashShell = getSplashShell(display);
        splashShell.open();
        
        
        
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;

        this.shell = new Shell(display);
        this.shell.setLayout(gridLayout);
        this.shell.setText(getProperty("tuxguitar.title"));
        this.shell.setImage(new Image(display, TuxGuitar.getResourcePath(this, "icon.png")));    
        
        this.songManager = new SongManager();
        this.tablatureEditor = new TablatureEditor(this.songManager);
        
        initActions();
        initItems();

        tablatureEditor.showTablature(shell);                
                
            
        shell.setSize(640, 480);
        shell.open();
        
        splashShell.close();
        splashShell.dispose();
        while (!shell.isDisposed()) {
            if (!display.readAndDispatch()) {
                display.sleep();
            }

        }
        display.dispose();
        songManager.getPlayer().close();
        System.exit(0);
    }

    
    private Shell getSplashShell(Display display){        
        Shell shell = new Shell(display,SWT.NO_TRIM | SWT.NO_BACKGROUND);        
        final Image image = new Image(display, TuxGuitar.getResourcePath(this, "splash.png"));                             
        int width =  image.getBounds().width;
        int height =  image.getBounds().height;
        int x = ((display.getBounds().width - display.getBounds().x) / 2) - (width / 2);
        int y = ((display.getBounds().height - display.getBounds().y) / 2) - (height / 2);        
        shell.setBounds(x,y,width,height);        
        shell.setImage(new Image(display, TuxGuitar.getResourcePath(this, "icon.png"))); 
        shell.setText(getProperty("tuxguitar.title"));
        shell.addPaintListener(new PaintListener() {
            public void paintControl(PaintEvent e) {
              e.gc.drawImage(image,0,0);
            }
          });              
        return shell;       
    }
    
    
    private void initItems(){
        this.itemContainerManager = new ItemContainerManager(this.tablatureEditor);
        this.itemContainerManager.createMenu(this.shell);
        this.itemContainerManager.createToolbar(this.shell);
    }
    
    private void initActions(){
        this.actionContainer = new ActionContainer(this.tablatureEditor);
        this.actionContainer.initActions();
    }
    
    public Action getAction(String name){
        return this.actionContainer.getAction(name);
    }
    
    public ItemContainerManager getItemContainerManager() {
        return itemContainerManager;
    }    
    
    public ActionContainer getActionContainer(){
        return this.actionContainer;
    }
    
    public LanguageManager getLanguageManager(){
        return this.languageManager;
    }
    
    public static String getProperty(String key) {
        return TuxGuitar.instance().languageManager.getProperty(key);
    }
    
    
    public static String getResourcePath(Object o, String file) {
        return TuxGuitar.instance().basePath + "files" + File.separator + file;
    }
    
    
    
    public String getBasePath(){
        return this.basePath;
    }

}