/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import java.io.Serializable;
import org.herac.tuxguitar.song.models.Tupleto;

public class Duration
implements Serializable {
    public static final long QUARTER_TIME = 1000L;
    public static final int WHOLE = 1;
    public static final int HALF = 2;
    public static final int QUARTER = 4;
    public static final int EIGHTH = 8;
    public static final int SIXTEENTH = 16;
    public static final int THIRTY_SECOND = 32;
    public static final int SIXTY_FOURTH = 64;
    public static final Tupleto NO_TUPLETO = new Tupleto(1, 1);
    private int value;
    private boolean dotted;
    private boolean doubleDotted;
    private Tupleto tupleto;

    public Duration(int n, boolean bl, boolean bl2, Tupleto tupleto) {
        this.value = n;
        this.dotted = bl;
        this.doubleDotted = bl2;
        this.tupleto = tupleto;
    }

    public Duration(int n) {
        this(n, false, false, new Tupleto(1, 1));
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public boolean isDotted() {
        return this.dotted;
    }

    public void setDotted(boolean bl) {
        this.dotted = bl;
    }

    public boolean isDoubleDotted() {
        return this.doubleDotted;
    }

    public void setDoubleDotted(boolean bl) {
        this.doubleDotted = bl;
    }

    public Tupleto getTupleto() {
        return this.tupleto;
    }

    public long getTime() {
        long l = 0L;
        switch (this.value) {
            case 1: {
                l = 4000L;
                break;
            }
            case 2: {
                l = 2000L;
                break;
            }
            case 4: {
                l = 1000L;
                break;
            }
            case 8: {
                l = 500L;
                break;
            }
            case 16: {
                l = 250L;
                break;
            }
            case 32: {
                l = 125L;
                break;
            }
            case 64: {
                l = 62L;
            }
        }
        if (this.dotted) {
            l += l / 2L;
        } else if (this.doubleDotted) {
            l += l / 4L * 3L;
        }
        return this.tupleto.convertTime(l);
    }

    public Object clone() {
        return new Duration(this.value, this.dotted, this.doubleDotted, (Tupleto)this.tupleto.clone());
    }
}

