/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.play.models.midiplayer;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import org.herac.tuxguitar.play.models.Player;
import org.herac.tuxguitar.play.models.midiplayer.MeasureStartMetaEventListener;
import org.herac.tuxguitar.play.models.midiplayer.SongSequence;
import org.herac.tuxguitar.song.managers.SongManager;

public class SongPlayer
implements Player {
    private SongManager songManager;
    private Sequencer sequencer;
    private MeasureStartMetaEventListener controller;
    private boolean running;
    private boolean changeTickPosition;
    private long tickPosition;

    public SongPlayer(SongManager songManager) {
        this.songManager = songManager;
        this.controller = new MeasureStartMetaEventListener();
        this.init();
        this.reset();
    }

    private Sequencer getSequencer() {
        try {
            if (this.sequencer == null) {
                this.sequencer = MidiSystem.getSequencer();
            }
            if (!this.sequencer.isOpen()) {
                this.sequencer.open();
            }
            return this.sequencer;
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
            return null;
        }
    }

    public void init() {
        this.getSequencer().addMetaEventListener(this.controller);
    }

    public void reset() {
        this.stop();
        this.tickPosition = 1000L;
        this.setChangeTickPosition(false);
        this.controller.reset();
    }

    public void close() {
        this.setRunning(false);
        this.getSequencer().close();
    }

    public void stop() {
        Sequencer sequencer = this.getSequencer();
        if (sequencer != null && sequencer.isRunning()) {
            sequencer.stop();
        }
        this.setRunning(false);
    }

    public void play() {
        this.stop();
        this.setRunning(true);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SongPlayer.this.addSecuence();
                    SongPlayer.this.getSequencer().start();
                    SongPlayer.this.getSequencer().setTickPosition(SongPlayer.this.tickPosition - 500L);
                    SongPlayer.this.setChangeTickPosition(false);
                    while (SongPlayer.this.getSequencer().isRunning()) {
                        if (SongPlayer.this.isChangeTickPosition()) {
                            SongPlayer.this.getSequencer().setTickPosition(SongPlayer.this.tickPosition - 500L);
                            SongPlayer.this.setChangeTickPosition(false);
                        }
                        Thread.sleep(10L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                catch (InvalidMidiDataException invalidMidiDataException) {
                    SongPlayer.this.close();
                    SongPlayer.this.init();
                    invalidMidiDataException.printStackTrace();
                }
                finally {
                    SongPlayer.this.reset();
                }
            }
        }).start();
    }

    public void setTickPosition(long l) {
        this.tickPosition = l;
        this.setChangeTickPosition(true);
    }

    public void setRunning(boolean bl) {
        this.running = bl;
    }

    public boolean isRunning() {
        return this.running;
    }

    private boolean isChangeTickPosition() {
        return this.changeTickPosition;
    }

    private void setChangeTickPosition(boolean bl) {
        this.changeTickPosition = bl;
    }

    public long getTickPosition() {
        return this.controller.getTickPosition();
    }

    public void addSecuence() throws InvalidMidiDataException {
        SongSequence songSequence = new SongSequence(this.songManager);
        songSequence.createSongSecuence();
        this.getSequencer().setSequence(songSequence.getSongSecuence());
    }

    public Soundbank getDefaultSoundbank() {
        Sequencer sequencer = this.getSequencer();
        if (sequencer instanceof Synthesizer) {
            Synthesizer synthesizer = (Synthesizer)((Object)sequencer);
            return synthesizer.getDefaultSoundbank();
        }
        return null;
    }
}

