/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.herac.tuxguitar.io.SongLoader;
import org.herac.tuxguitar.io.gp.GPFormatException;
import org.herac.tuxguitar.io.tg.TGOutputStream;
import org.herac.tuxguitar.song.models.Song;

public class TGConverter {
    private String sourceFolder;
    private String destinationFolder;

    public TGConverter(String string, String string2) {
        this.sourceFolder = string;
        this.destinationFolder = string2;
    }

    public void convert(String string, String string2) throws GPFormatException, IOException {
        Song song = new SongLoader(string).load();
        if (song != null) {
            new TGOutputStream(string2).write(song);
        }
    }

    private void process(File file) {
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file.getPath() + "/" + stringArray[i]);
            if (file2.isDirectory()) {
                this.process(file2);
            } else {
                String string = this.getConvertFile(file2.getPath());
                if (this.isSuportedFile(string)) {
                    string = this.replaceExtension(string);
                    new File(new File(string).getParent()).mkdirs();
                    try {
                        System.out.print(string);
                        this.convert(file2.getPath(), string);
                        System.out.println(" [OK] ");
                    }
                    catch (Exception exception) {
                        System.out.println(string + " [FAILED] ");
                        System.out.println(" ********** REASON: " + exception.getClass().getName() + " ********** ");
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        System.out.println(string + "  [FAILED]  ");
                        System.out.println(" ********** REASON: OutOfMemoryError ********** ");
                    }
                }
            }
            stringArray[i] = null;
        }
    }

    private String getConvertFile(String string) {
        String string2 = this.destinationFolder + string.substring(this.sourceFolder.length());
        return string2;
    }

    private boolean isSuportedFile(String string) {
        return string.endsWith(".gp3") || string.endsWith(".gp4");
    }

    private String replaceExtension(String string) {
        if (string.endsWith(".gp3") || string.endsWith(".gp4")) {
            string = string.replaceAll(".gp3", ".tg");
            string = string.replaceAll(".gp4", ".tg");
        }
        return string;
    }

    private void writeSong(String string, Song song) {
        try {
            new TGOutputStream(string).write(song);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length >= 2) {
            String string = stringArray[0];
            String string2 = stringArray[1];
            TGConverter tGConverter = new TGConverter(string, string2);
            File file = new File(string);
            tGConverter.process(file);
        } else {
            TGConverter.showHelp();
        }
    }

    private static void showHelp() {
        System.out.println("usage options:  [SOURCE FOLDER] [DESTINATION FOLDER]");
    }
}

