/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.DurationCoords;
import org.herac.tuxguitar.gui.tab.MeasureComponent;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Silence;

public class SilenceCoords
implements MeasureComponent {
    private Tablature tablature;
    private MeasureCoords meassureCoords;
    private Silence silence;
    private Image image;
    private int posX;
    private int posY;
    private DurationCoords durationCoords;
    private int span;
    private int pointX;
    private int pointY;

    public SilenceCoords(Tablature tablature, MeasureCoords measureCoords, Silence silence, int n, int n2) {
        this.tablature = tablature;
        this.meassureCoords = measureCoords;
        this.silence = silence;
        this.posX = n;
        this.posY = n2;
    }

    public void update() {
        String string;
        String string2;
        if (this.getDuration() != null && (string2 = TuxGuitar.getResourcePath(this, string = "silence" + this.getDuration().getValue() + ".gif")) != null) {
            this.image = new Image((Device)this.tablature.getDisplay(), string2);
        }
    }

    public void paint(GC gC, int n, int n2) {
        if (this.silence != null && this.image != null) {
            int n3 = this.meassureCoords.getHeight() / 2;
            int n4 = this.posX + n - 10 + this.getSpan();
            int n5 = n2 + (n3 - 10);
            gC.drawImage(this.image, n4, n5);
            this.pointX = n4 + 10;
            if (this.silence.getDuration().isDotted() || this.silence.getDuration().isDoubleDotted()) {
                gC.drawOval(n4 + 23, n5 + 15, 1, 1);
                if (this.silence.getDuration().isDoubleDotted()) {
                    gC.drawOval(n4 + 26, n5 + 15, 1, 1);
                }
            }
            if (!this.silence.getDuration().getTupleto().isEqual(Duration.NO_TUPLETO)) {
                gC.drawString(Integer.toString(this.silence.getDuration().getTupleto().getEnters()), n4 + 15, n5 + 81);
            }
        } else {
            int n6 = this.posX + n + 3 + this.getSpan();
            int n7 = this.posY + n2 + 15;
            gC.drawString("S", n6, n7);
        }
    }

    public void setDuration(Duration duration) {
        this.silence.setDuration(duration);
    }

    public Duration getDuration() {
        return this.silence.getDuration();
    }

    public void setStart(long l) {
        this.silence.setStart(l);
    }

    public long getStart() {
        return this.silence.getStart();
    }

    public Silence getSilence() {
        return this.silence;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getSpan() {
        return this.span;
    }

    public void setSpan(int n) {
        this.span = n;
    }

    public int getPointX() {
        return this.pointX;
    }

    public int getPointY() {
        return this.pointY;
    }
}

