/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ItemContainer;
import org.herac.tuxguitar.gui.tab.LinearViewLayout;
import org.herac.tuxguitar.gui.tab.PageViewLayout;

public class LayoutMenuItem
implements ItemContainer {
    private TablatureEditor tablatureEditor;
    private MenuItem layoutMenuItem;
    private Menu menu;
    private MenuItem pageLayout;
    private MenuItem linearLayout;
    private MenuItem multitrack;

    public LayoutMenuItem(Shell shell, Menu menu, int n, TablatureEditor tablatureEditor) {
        this.layoutMenuItem = new MenuItem(menu, n);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.pageLayout = new MenuItem(this.menu, 16);
        this.pageLayout.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SET_PAGE_LAYOUT"));
        this.linearLayout = new MenuItem(this.menu, 16);
        this.linearLayout.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SET_LINEAR_LAYOUT"));
        this.multitrack = new MenuItem(this.menu, 32);
        this.multitrack.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SET_MULTITRACK_VIEW"));
        this.layoutMenuItem.setMenu(this.menu);
        this.loadProperties();
    }

    public void update() {
        this.pageLayout.setSelection(this.tablatureEditor.getTablature().getViewLayout() instanceof PageViewLayout);
        this.linearLayout.setSelection(this.tablatureEditor.getTablature().getViewLayout() instanceof LinearViewLayout);
        this.multitrack.setSelection(this.tablatureEditor.getTablature().getViewLayout().isMultitrack());
    }

    public void loadProperties() {
        this.layoutMenuItem.setText(TuxGuitar.getProperty("layout"));
        this.pageLayout.setText(TuxGuitar.getProperty("layout.page"));
        this.linearLayout.setText(TuxGuitar.getProperty("layout.linear"));
        this.multitrack.setText(TuxGuitar.getProperty("layout.multitrack"));
    }
}

